/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api.mvcc;

import java.util.Collections;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.api.mvcc.LockAssert;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.invocation.InvocationContextContainer;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.LockManager;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "mvcc"})
public abstract class LockTestBase {
    protected Fqn A = Fqn.fromString((String)"/a");
    protected Fqn AB = Fqn.fromString((String)"/a/b");
    protected Fqn ABC = Fqn.fromString((String)"/a/b/c");
    protected Fqn ABCD = Fqn.fromString((String)"/a/b/c/d");
    protected boolean repeatableRead = true;
    protected boolean lockParentForChildInsertRemove = false;
    protected ThreadLocal<LockTestBaseTL> threadLocal = new ThreadLocal();

    @BeforeMethod
    public void setUp() {
        LockTestBaseTL tl = new LockTestBaseTL();
        tl.cache = new UnitTestCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL), false);
        tl.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.MVCC);
        tl.cache.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        tl.cache.getConfiguration().setIsolationLevel(this.repeatableRead ? IsolationLevel.REPEATABLE_READ : IsolationLevel.READ_COMMITTED);
        tl.cache.getConfiguration().setLockParentForChildInsertRemove(this.lockParentForChildInsertRemove);
        tl.cache.getConfiguration().setLockAcquisitionTimeout(200L);
        tl.cache.start();
        tl.lockManager = (LockManager)TestingUtil.extractComponentRegistry(tl.cache).getComponent(LockManager.class);
        tl.icc = (InvocationContextContainer)TestingUtil.extractComponentRegistry(tl.cache).getComponent(InvocationContextContainer.class);
        tl.tm = (TransactionManager)TestingUtil.extractComponentRegistry(tl.cache).getComponent(TransactionManager.class);
        this.threadLocal.set(tl);
    }

    @AfterMethod
    public void tearDown() {
        LockTestBaseTL tl = this.threadLocal.get();
        TestingUtil.killCaches(tl.cache);
        this.threadLocal.set(null);
    }

    protected void assertLocked(Fqn fqn) {
        LockTestBaseTL tl = this.threadLocal.get();
        LockAssert.assertLocked(fqn, tl.lockManager, tl.icc);
    }

    protected void assertNotLocked(Fqn fqn) {
        LockTestBaseTL tl = this.threadLocal.get();
        LockAssert.assertNotLocked(fqn, tl.lockManager, tl.icc);
    }

    protected void assertNoLocks() {
        LockTestBaseTL tl = this.threadLocal.get();
        LockAssert.assertNoLocks(tl.lockManager, tl.icc);
    }

    public void testLocksOnPutKeyVal() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        tl.tm.begin();
        tl.cache.put(this.AB, (Object)"k", (Object)"v");
        if (this.lockParentForChildInsertRemove) {
            this.assertLocked(Fqn.ROOT);
        } else {
            this.assertNotLocked(Fqn.ROOT);
        }
        this.assertLocked(this.A);
        this.assertLocked(this.AB);
        this.assertNotLocked(this.ABC);
        tl.tm.commit();
        this.assertNoLocks();
        tl.tm.begin();
        assert (((String)tl.cache.get(this.AB, (Object)"k")).equals("v"));
        this.assertNotLocked(Fqn.ROOT);
        this.assertNotLocked(this.A);
        this.assertNotLocked(this.AB);
        this.assertNotLocked(this.ABC);
        tl.tm.commit();
        this.assertNoLocks();
        tl.tm.begin();
        tl.cache.put(this.ABC, (Object)"k", (Object)"v");
        this.assertNotLocked(Fqn.ROOT);
        this.assertNotLocked(this.A);
        if (this.lockParentForChildInsertRemove) {
            this.assertLocked(this.AB);
        } else {
            this.assertNotLocked(this.AB);
        }
        this.assertLocked(this.ABC);
        tl.tm.commit();
        this.assertNoLocks();
    }

    public void testLocksOnPutData() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        tl.tm.begin();
        tl.cache.put(this.AB, Collections.singletonMap("k", "v"));
        if (this.lockParentForChildInsertRemove) {
            this.assertLocked(Fqn.ROOT);
        } else {
            this.assertNotLocked(Fqn.ROOT);
        }
        this.assertLocked(this.A);
        this.assertLocked(this.AB);
        this.assertNotLocked(this.ABC);
        assert ("v".equals(tl.cache.get(this.AB, (Object)"k")));
        tl.tm.commit();
        assert ("v".equals(tl.cache.get(this.AB, (Object)"k")));
        this.assertNoLocks();
        tl.tm.begin();
        assert ("v".equals(tl.cache.get(this.AB, (Object)"k")));
        this.assertNotLocked(Fqn.ROOT);
        this.assertNotLocked(this.A);
        this.assertNotLocked(this.AB);
        this.assertNotLocked(this.ABC);
        tl.tm.commit();
        this.assertNoLocks();
        tl.tm.begin();
        tl.cache.put(this.ABC, Collections.singletonMap("k", "v"));
        this.assertNotLocked(Fqn.ROOT);
        this.assertNotLocked(this.A);
        if (this.lockParentForChildInsertRemove) {
            this.assertLocked(this.AB);
        } else {
            this.assertNotLocked(this.AB);
        }
        this.assertLocked(this.ABC);
        tl.tm.commit();
        this.assertNoLocks();
    }

    public void testLocksOnRemoveNode() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        tl.cache.put(this.AB, Collections.singletonMap("k", "v"));
        assert ("v".equals(tl.cache.get(this.AB, (Object)"k")));
        tl.tm.begin();
        tl.cache.removeNode(this.AB);
        this.assertLocked(this.AB);
        if (this.lockParentForChildInsertRemove) {
            this.assertLocked(this.A);
        } else {
            this.assertNotLocked(this.A);
        }
        this.assertNotLocked(Fqn.ROOT);
        tl.tm.commit();
        assert (tl.cache.getNode(this.AB) == null) : "Should not exist";
        this.assertNoLocks();
    }

    public void testLocksOnEvictNode() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        tl.cache.put(this.AB, Collections.singletonMap("k", "v"));
        assert ("v".equals(tl.cache.get(this.AB, (Object)"k")));
        tl.tm.begin();
        tl.cache.evict(this.AB);
        this.assertLocked(this.AB);
        if (this.lockParentForChildInsertRemove) {
            this.assertLocked(this.A);
        } else {
            this.assertNotLocked(this.A);
        }
        this.assertNotLocked(Fqn.ROOT);
        tl.tm.commit();
        assert (tl.cache.getNode(this.AB) == null) : "Should not exist";
        this.assertNoLocks();
    }

    public void testLocksOnEvictRecursiveNode() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        tl.cache.put(this.AB, Collections.singletonMap("k", "v"));
        tl.cache.put(this.ABC, Collections.singletonMap("k", "v"));
        tl.cache.put(this.ABCD, Collections.singletonMap("k", "v"));
        assert ("v".equals(tl.cache.get(this.AB, (Object)"k")));
        assert ("v".equals(tl.cache.get(this.ABC, (Object)"k")));
        assert ("v".equals(tl.cache.get(this.ABCD, (Object)"k")));
        tl.tm.begin();
        tl.cache.evict(this.AB, true);
        this.assertLocked(this.AB);
        this.assertLocked(this.ABC);
        this.assertLocked(this.ABCD);
        if (this.lockParentForChildInsertRemove) {
            this.assertLocked(this.A);
        } else {
            this.assertNotLocked(this.A);
        }
        this.assertNotLocked(Fqn.ROOT);
        tl.tm.commit();
        assert (tl.cache.getNode(this.AB) == null) : "Should not exist";
        this.assertNoLocks();
    }

    public void testLocksOnRemoveNonexistentNode() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        assert (tl.cache.getNode(this.AB) == null) : "Should not exist";
        tl.tm.begin();
        tl.cache.removeNode(this.AB);
        this.assertLocked(this.AB);
        if (this.lockParentForChildInsertRemove) {
            this.assertLocked(this.A);
        } else {
            this.assertNotLocked(this.A);
        }
        this.assertNotLocked(Fqn.ROOT);
        tl.tm.commit();
        assert (tl.cache.getNode(this.AB) == null) : "Should not exist";
        this.assertNoLocks();
    }

    public void testLocksOnEvictNonexistentNode() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        assert (tl.cache.getNode(this.AB) == null) : "Should not exist";
        tl.tm.begin();
        tl.cache.evict(this.AB);
        this.assertLocked(this.AB);
        if (this.lockParentForChildInsertRemove) {
            this.assertLocked(this.A);
        } else {
            this.assertNotLocked(this.A);
        }
        this.assertNotLocked(Fqn.ROOT);
        tl.tm.commit();
        assert (tl.cache.getNode(this.AB) == null) : "Should not exist";
        this.assertNoLocks();
    }

    public void testLocksOnRemoveData() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        tl.cache.put(this.AB, (Object)"k", (Object)"v");
        tl.cache.put(this.AB, (Object)"k2", (Object)"v2");
        assert ("v".equals(tl.cache.get(this.AB, (Object)"k")));
        assert ("v2".equals(tl.cache.get(this.AB, (Object)"k2")));
        tl.tm.begin();
        Object x = tl.cache.remove(this.AB, (Object)"k");
        assert (x.equals("v"));
        this.assertLocked(this.AB);
        this.assertNotLocked(this.A);
        this.assertNotLocked(Fqn.ROOT);
        tl.tm.commit();
        assert (tl.cache.get(this.AB, (Object)"k") == null) : "Should not exist";
        assert ("v2".equals(tl.cache.get(this.AB, (Object)"k2")));
        this.assertNoLocks();
        tl.tm.begin();
        tl.cache.clearData(this.AB);
        this.assertLocked(this.AB);
        this.assertNotLocked(this.A);
        this.assertNotLocked(Fqn.ROOT);
        tl.tm.commit();
        assert (tl.cache.get(this.AB, (Object)"k") == null) : "Should not exist";
        assert (tl.cache.get(this.AB, (Object)"k2") == null) : "Should not exist";
        this.assertNoLocks();
        assert (tl.cache.get(this.AB, (Object)"k3") == null) : "Should not exist";
        tl.tm.begin();
        tl.cache.remove(this.AB, (Object)"k3");
        this.assertLocked(this.AB);
        this.assertNotLocked(this.A);
        this.assertNotLocked(Fqn.ROOT);
        tl.tm.commit();
        this.assertNoLocks();
    }

    public void testLocksOnRemoveDataNonExistentNode() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        assert (tl.cache.getNode(this.AB) == null) : "Should not exist";
        tl.tm.begin();
        tl.cache.remove(this.AB, (Object)"k");
        this.assertNotLocked(this.AB);
        this.assertNotLocked(this.A);
        this.assertNotLocked(Fqn.ROOT);
        tl.tm.commit();
        assert (tl.cache.getNode(this.AB) == null) : "Should not exist";
    }

    public void testReadMethods() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        tl.cache.put(this.AB, (Object)"k", (Object)"v");
        tl.tm.begin();
        assert ("v".equals(tl.cache.get(this.AB, (Object)"k")));
        this.assertNoLocks();
        tl.tm.commit();
        this.assertNoLocks();
        tl.tm.begin();
        assert (tl.cache.getData(this.AB).containsKey("k"));
        this.assertNoLocks();
        tl.tm.commit();
        this.assertNoLocks();
        tl.tm.begin();
        assert (tl.cache.getKeys(this.AB).contains("k"));
        this.assertNoLocks();
        tl.tm.commit();
        this.assertNoLocks();
        tl.tm.begin();
        assert (tl.cache.getNode(this.AB) != null);
        this.assertNoLocks();
        tl.tm.commit();
        this.assertNoLocks();
        tl.tm.begin();
        assert (tl.cache.getNode(this.A) != null);
        assert (!tl.cache.getNode(this.A).getChildrenNames().isEmpty());
        assert (tl.cache.getNode(this.A).getChildrenNames().contains(this.AB.getLastElement()));
        this.assertNoLocks();
        tl.tm.commit();
        this.assertNoLocks();
    }

    public void testWriteDoesntBlockRead() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        tl.cache.put(this.AB, (Object)"k", (Object)"v");
        tl.tm.begin();
        tl.cache.put(this.AB, (Object)"k2", (Object)"v2");
        this.assertLocked(this.AB);
        Transaction write = tl.tm.suspend();
        tl.tm.begin();
        assert ("v".equals(tl.cache.get(this.AB, (Object)"k")));
        assert (null == tl.cache.get(this.AB, (Object)"k2")) : "Should not see uncommitted changes";
        Transaction read = tl.tm.suspend();
        tl.tm.resume(write);
        tl.tm.commit();
        this.assertNoLocks();
        tl.tm.resume(read);
        if (this.repeatableRead) {
            assert (null == tl.cache.get(this.AB, (Object)"k2")) : "Should have repeatable read";
        } else assert ("v2".equals(tl.cache.get(this.AB, (Object)"k2"))) : "Read committed should see committed changes";
        tl.tm.commit();
        this.assertNoLocks();
    }

    public void testWriteDoesntBlockReadNonexistent() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        tl.tm.begin();
        tl.cache.put(this.AB, (Object)"k", (Object)"v");
        this.assertLocked(this.AB);
        Transaction write = tl.tm.suspend();
        tl.tm.begin();
        assert (null == tl.cache.get(this.AB, (Object)"k")) : "Should not see uncommitted changes";
        assert (null == tl.cache.getNode(this.AB));
        Transaction read = tl.tm.suspend();
        tl.tm.resume(write);
        tl.tm.commit();
        this.assertNoLocks();
        tl.tm.resume(read);
        if (this.repeatableRead) {
            assert (null == tl.cache.get(this.AB, (Object)"k")) : "Should have repeatable read";
            assert (null == tl.cache.getNode(this.AB));
        } else {
            assert ("v".equals(tl.cache.get(this.AB, (Object)"k"))) : "Read committed should see committed changes";
            assert (null != tl.cache.getNode(this.AB));
        }
        tl.tm.commit();
        this.assertNoLocks();
    }

    public void testConcurrentWriters() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        tl.tm.begin();
        tl.cache.put(this.AB, (Object)"k", (Object)"v");
        Transaction t1 = tl.tm.suspend();
        tl.tm.begin();
        try {
            tl.cache.put(this.AB, (Object)"k", (Object)"v");
            assert (false) : "Should fail lock acquisition";
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        tl.tm.commit();
        tl.tm.resume(t1);
        tl.tm.commit();
        this.assertNoLocks();
    }

    public void testRollbacks() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        tl.cache.put(this.AB, (Object)"k", (Object)"v");
        tl.tm.begin();
        assert ("v".equals(tl.cache.get(this.AB, (Object)"k")));
        Transaction reader = tl.tm.suspend();
        tl.tm.begin();
        tl.cache.put(this.AB, (Object)"k", (Object)"v2");
        tl.tm.rollback();
        tl.tm.resume(reader);
        assert ("v".equals(tl.cache.get(this.AB, (Object)"k"))) : "Expecting 'v' but was " + (String)tl.cache.get(this.AB, (Object)"k");
        tl.tm.commit();
        assert ("v".equals(tl.cache.get(this.AB, (Object)"k")));
        this.assertNoLocks();
    }

    public void testRollbacksOnNullNode() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        tl.tm.begin();
        assert (null == tl.cache.get(this.AB, (Object)"k"));
        assert (null == tl.cache.getNode(this.AB));
        Transaction reader = tl.tm.suspend();
        tl.tm.begin();
        tl.cache.put(this.AB, (Object)"k", (Object)"v");
        assert (null != tl.cache.getNode(this.AB));
        assert ("v".equals(tl.cache.get(this.AB, (Object)"k")));
        tl.tm.rollback();
        tl.tm.resume(reader);
        assert (null == tl.cache.get(this.AB, (Object)"k")) : "Expecting null but was " + (String)tl.cache.get(this.AB, (Object)"k");
        assert (null == tl.cache.getNode(this.AB));
        tl.tm.commit();
        assert (null == tl.cache.get(this.AB, (Object)"k"));
        assert (null == tl.cache.getNode(this.AB));
        this.assertNoLocks();
    }

    public void testPhantomChildren() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        tl.cache.put(this.AB, (Object)"k", (Object)"v");
        assert (tl.cache.getNode(this.AB).getChildren().size() == 0);
        assert (tl.cache.getNode(this.A).getChildren().size() == 1);
        tl.tm.begin();
        tl.cache.put(this.ABC, (Object)"k", (Object)"v");
        assert (tl.cache.getRoot().hasChild(this.ABC));
        assert (tl.cache.getNode(this.ABC) != null);
        assert (tl.cache.getNode(this.AB).getChild(this.ABC.getLastElement()) != null);
        assert (tl.cache.getNode(this.AB).getChildren().size() == 1);
        Transaction t = tl.tm.suspend();
        assert (tl.cache.getNode(this.ABC) == null);
        assert (tl.cache.getNode(this.AB).getChild(this.ABC.getLastElement()) == null);
        assert (tl.cache.getNode(this.AB).getChildren().size() == 0);
        tl.tm.resume(t);
        assert (tl.cache.getRoot().hasChild(this.ABC));
        assert (tl.cache.getNode(this.ABC) != null);
        tl.tm.commit();
        assert (tl.cache.getNode(this.ABC) != null);
        assert (tl.cache.getNode(this.AB).getChild(this.ABC.getLastElement()) != null);
        assert (tl.cache.getNode(this.AB).getChildren().size() == 1);
    }

    public void testChildCount() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        tl.cache.put(this.AB, (Object)"k", (Object)"v");
        assert (tl.cache.getNode(this.AB).getChildren().size() == 0);
        assert (tl.cache.getNode(this.A).getChildren().size() == 1);
        tl.tm.begin();
        assert (tl.cache.getNode(this.AB).getChildren().size() == 0);
        assert (tl.cache.getNode(this.A).getChildren().size() == 1);
        tl.cache.removeNode(this.AB);
        assert (tl.cache.getNode(this.A).getChildren().size() == 0);
        assert (!tl.cache.getNode(this.A).hasChild(this.AB.getLastElement()));
        assert (tl.cache.getNode(this.AB) == null);
        Transaction t = tl.tm.suspend();
        assert (tl.cache.getNode(this.AB) != null);
        assert (tl.cache.getNode(this.A).getChild(this.AB.getLastElement()) != null);
        assert (tl.cache.getNode(this.A).getChildren().size() == 1);
        tl.tm.resume(t);
        assert (tl.cache.getNode(this.A).getChildren().size() == 0);
        assert (!tl.cache.getNode(this.A).hasChild(this.AB.getLastElement()));
        assert (tl.cache.getNode(this.AB) == null);
        tl.tm.commit();
        assert (tl.cache.getNode(this.A).getChildren().size() == 0);
        assert (!tl.cache.getNode(this.A).hasChild(this.AB.getLastElement()));
        assert (tl.cache.getNode(this.AB) == null);
    }

    public void testOverwritingOnInsert() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        tl.cache.put(this.AB, (Object)"k", (Object)"v");
        tl.tm.begin();
        tl.cache.put(this.ABC, (Object)"k", (Object)"v");
        assert ("v".equals(tl.cache.get(this.ABC, (Object)"k")));
        assert ("v".equals(tl.cache.get(this.AB, (Object)"k")));
        Transaction t1 = tl.tm.suspend();
        tl.tm.begin();
        tl.cache.put(this.AB, (Object)"k", (Object)"v2");
        assert ("v2".equals(tl.cache.get(this.AB, (Object)"k")));
        assert (null == tl.cache.get(this.ABC, (Object)"k"));
        Transaction t2 = tl.tm.suspend();
        tl.tm.resume(t1);
        t1.commit();
        assert ("v".equals(tl.cache.get(this.AB, (Object)"k")));
        assert ("v".equals(tl.cache.get(this.ABC, (Object)"k")));
        tl.tm.resume(t2);
        t2.commit();
        assert ("v2".equals(tl.cache.get(this.AB, (Object)"k")));
        assert ("v".equals(tl.cache.get(this.ABC, (Object)"k")));
    }

    public void testOverwritingOnInsert2() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        tl.cache.put(this.AB, (Object)"k", (Object)"v");
        tl.tm.begin();
        tl.cache.put(this.AB, (Object)"k", (Object)"v2");
        assert ("v2".equals(tl.cache.get(this.AB, (Object)"k")));
        assert (null == tl.cache.get(this.ABC, (Object)"k"));
        Transaction t1 = tl.tm.suspend();
        tl.tm.begin();
        tl.cache.put(this.ABC, (Object)"k", (Object)"v");
        assert ("v".equals(tl.cache.get(this.ABC, (Object)"k")));
        assert ("v".equals(tl.cache.get(this.AB, (Object)"k")));
        Transaction t2 = tl.tm.suspend();
        tl.tm.resume(t1);
        t1.commit();
        assert ("v2".equals(tl.cache.get(this.AB, (Object)"k")));
        assert (null == tl.cache.get(this.ABC, (Object)"k"));
        tl.tm.resume(t2);
        t2.commit();
        assert ("v2".equals(tl.cache.get(this.AB, (Object)"k")));
        assert ("v".equals(tl.cache.get(this.ABC, (Object)"k")));
    }

    public void testOverwritingOnInsert3() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        tl.cache.put(this.AB, (Object)"k", (Object)"v");
        tl.tm.begin();
        tl.cache.put(this.AB, (Object)"k", (Object)"v2");
        assert ("v2".equals(tl.cache.get(this.AB, (Object)"k")));
        assert (null == tl.cache.get(this.ABC, (Object)"k"));
        Transaction t1 = tl.tm.suspend();
        tl.tm.begin();
        tl.cache.put(this.ABC, (Object)"k", (Object)"v");
        assert ("v".equals(tl.cache.get(this.ABC, (Object)"k")));
        assert ("v".equals(tl.cache.get(this.AB, (Object)"k")));
        tl.tm.commit();
        assert ("v".equals(tl.cache.get(this.ABC, (Object)"k")));
        assert ("v".equals(tl.cache.get(this.AB, (Object)"k")));
        tl.tm.resume(t1);
        t1.commit();
        assert ("v2".equals(tl.cache.get(this.AB, (Object)"k")));
        assert ("v".equals(tl.cache.get(this.ABC, (Object)"k")));
    }

    public void testConcurrentInsertRemove1() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        tl.cache.put(this.AB, (Object)"k", (Object)"v");
        tl.tm.begin();
        tl.cache.put(this.ABC, (Object)"k", (Object)"v");
        assert ("v".equals(tl.cache.get(this.AB, (Object)"k")));
        assert ("v".equals(tl.cache.get(this.ABC, (Object)"k")));
        Transaction t1 = tl.tm.suspend();
        tl.tm.begin();
        tl.cache.removeNode(this.AB);
        assert (null == tl.cache.get(this.ABC, (Object)"k"));
        assert (null == tl.cache.get(this.AB, (Object)"k"));
        tl.tm.commit();
        assert (null == tl.cache.get(this.ABC, (Object)"k"));
        assert (null == tl.cache.get(this.AB, (Object)"k"));
        tl.tm.resume(t1);
        t1.commit();
        assert (null == tl.cache.get(this.ABC, (Object)"k"));
        assert (null == tl.cache.get(this.AB, (Object)"k"));
    }

    public void testConcurrentInsertRemove2() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        tl.cache.put(this.AB, (Object)"k", (Object)"v");
        tl.tm.begin();
        tl.cache.removeNode(this.AB);
        assert (null == tl.cache.get(this.ABC, (Object)"k"));
        assert (null == tl.cache.get(this.AB, (Object)"k"));
        Transaction t1 = tl.tm.suspend();
        tl.tm.begin();
        assert ("v".equals(tl.cache.get(this.AB, (Object)"k")));
        tl.cache.put(this.ABC, (Object)"k", (Object)"v");
        assert ("v".equals(tl.cache.get(this.ABC, (Object)"k")));
        tl.tm.commit();
        assert ("v".equals(tl.cache.get(this.AB, (Object)"k")));
        assert ("v".equals(tl.cache.get(this.ABC, (Object)"k")));
        tl.tm.resume(t1);
        t1.commit();
        assert (null == tl.cache.get(this.ABC, (Object)"k"));
        assert (null == tl.cache.get(this.AB, (Object)"k"));
    }

    protected class LockTestBaseTL {
        public Cache<String, String> cache;
        public TransactionManager tm;
        public LockManager lockManager;
        public InvocationContextContainer icc;

        protected LockTestBaseTL() {
        }
    }
}

