/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api.mvcc.read_committed;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.api.mvcc.LockAssert;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.invocation.InvocationContextContainer;
import org.jboss.cache.loader.DummySharedInMemoryCacheLoader;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.LockManager;
import org.jboss.cache.passivation.PassivationTestsBase;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "mvcc"})
public class PassivationTest
extends PassivationTestsBase {
    protected void configureCache() throws Exception {
        CacheSPI cache = (CacheSPI)this.cacheTL.get();
        cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.MVCC);
        cache.getConfiguration().setIsolationLevel(IsolationLevel.READ_COMMITTED);
        String binName = "bin-" + Thread.currentThread().getName();
        CacheLoaderConfig clc = this.getSingleCacheLoaderConfig("", DummySharedInMemoryCacheLoader.class.getName(), "debug=true,bin=" + binName, false, true, false);
        clc.setPassivation(true);
        cache.getConfiguration().setCacheLoaderConfig(clc);
    }

    @AfterMethod
    public void postTest() {
        CacheSPI cache = (CacheSPI)this.cacheTL.get();
        ComponentRegistry cr = TestingUtil.extractComponentRegistry((Cache)cache);
        LockAssert.assertNoLocks((LockManager)cr.getComponent(LockManager.class), (InvocationContextContainer)cr.getComponent(InvocationContextContainer.class));
    }
}

