/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import java.util.HashMap;
import java.util.Map;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.buddyreplication.BuddyReplicationTestsBase;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.util.CachePrinter;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public class BuddyBackupActivationInactivationTest
extends BuddyReplicationTestsBase {
    public static final Fqn A = Fqn.fromString((String)"/a");
    public static final Fqn A_B = Fqn.fromString((String)"/a/b");
    public static final String JOE = "JOE";
    protected ThreadLocal<Map<String, Cache>> cachesTL = new ThreadLocal();
    private ThreadLocal<ClassLoader> orig_TCL_TL = new ThreadLocal();

    public void testBuddyBackupActivation() throws Exception {
        CacheSPI<?, ?> cache1 = this.createCache("cache1", true, true, true);
        CacheSPI<?, ?> cache2 = this.createCache("cache2", true, true, true);
        Fqn A = Fqn.fromString((String)"/a");
        TestingUtil.blockUntilViewsReceived(5000L, new Cache[]{cache1, cache2});
        Region c1 = cache1.getRegionManager().getRegion(A, Region.Type.MARSHALLING, true);
        Region c2 = cache2.getRegionManager().getRegion(A, Region.Type.MARSHALLING, true);
        AssertJUnit.assertFalse((boolean)c1.isActive());
        AssertJUnit.assertFalse((boolean)c2.isActive());
        c1.activate();
        cache1.put(A_B, (Object)"name", (Object)JOE);
        System.out.println("Cache dump BEFORE activation");
        System.out.println("cache1 " + CachePrinter.printCacheDetails(cache1));
        System.out.println("cache2 " + CachePrinter.printCacheDetails(cache2));
        c2.activate();
        System.out.println("Cache dump AFTER activation");
        System.out.println("cache1 " + CachePrinter.printCacheDetails(cache1));
        System.out.println("cache2 " + CachePrinter.printCacheDetails(cache2));
        Fqn fqn = this.fqnTransformer.getBackupFqn(cache1.getLocalAddress(), A_B);
        AssertJUnit.assertEquals((String)"State transferred with activation", (Object)JOE, (Object)cache2.get(fqn, (Object)"name"));
    }

    public void testReplToInactiveRegion() throws Exception {
        CacheSPI<?, ?> cache1 = this.createCache("cache1", true, true, true);
        CacheSPI<?, ?> cache2 = this.createCache("cache2", true, true, true);
        TestingUtil.blockUntilViewsReceived(5000L, new Cache[]{cache1, cache2});
        Fqn backupFqn = this.fqnTransformer.getBackupFqn(cache1.getLocalAddress(), A_B);
        Fqn A = Fqn.fromString((String)"/a");
        Region regionA = cache1.getRegion(A, true);
        regionA.registerContextClassLoader(this.getClass().getClassLoader());
        regionA.activate();
        cache2.getRegionManager().activate(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN);
        cache2.getRegionManager().deactivate(A);
        cache1.put(A_B, (Object)"name", (Object)JOE);
        AssertJUnit.assertNull((String)"Should be no replication to inactive region", (Object)cache2.get(A_B, (Object)"name"));
        AssertJUnit.assertNull((String)"Should be no replication to inactive backup region", (Object)cache2.get(backupFqn, (Object)"name"));
    }

    public void testBuddyBackupInactivation() throws Exception {
        CacheSPI<?, ?> cache1 = this.createCache("cache1", true, true, true);
        Fqn A = Fqn.fromString((String)"/a");
        Region regionA = cache1.getRegion(A, true);
        regionA.registerContextClassLoader(this.getClass().getClassLoader());
        regionA.activate();
        Fqn fqn = Fqn.fromRelativeElements((Fqn)BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, (Object[])new String[]{"test"});
        fqn = Fqn.fromRelativeFqn((Fqn)fqn, (Fqn)A_B);
        cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        cache1.put(fqn, (Object)"name", (Object)JOE);
        AssertJUnit.assertEquals((String)"Put should have been OK", (Object)JOE, (Object)cache1.get(fqn, (Object)"name"));
        regionA.deactivate();
        AssertJUnit.assertNull((String)"Inactivation should have cleared region", (Object)cache1.get(fqn, (Object)"name"));
    }

    protected CacheSPI<?, ?> createCache(String cacheID, boolean sync, boolean useMarshalling, boolean startCache) throws Exception {
        Map<String, Cache> caches = this.cachesTL.get();
        if (caches.get(cacheID) != null) {
            throw new IllegalStateException(cacheID + " already created");
        }
        Configuration.CacheMode mode = sync ? Configuration.CacheMode.REPL_SYNC : Configuration.CacheMode.REPL_ASYNC;
        Configuration c = UnitTestCacheConfigurationFactory.createConfiguration(mode);
        CacheSPI cache = (CacheSPI)new UnitTestCacheFactory().createCache(c, false);
        if (useMarshalling) {
            cache.getConfiguration().setUseRegionBasedMarshalling(true);
            cache.getConfiguration().setInactiveOnStartup(true);
        }
        cache.getConfiguration().setBuddyReplicationConfig(this.getBuddyConfig());
        caches.put(cacheID, (Cache)cache);
        if (startCache) {
            cache.create();
            cache.start();
        }
        return cache;
    }

    @BeforeMethod(alwaysRun=true)
    protected void setUp() throws Exception {
        HashMap caches = new HashMap();
        this.cachesTL.set(caches);
        this.orig_TCL_TL.set(Thread.currentThread().getContextClassLoader());
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        super.tearDown();
        Thread.currentThread().setContextClassLoader(this.orig_TCL_TL.get());
        HashMap caches = new HashMap();
        for (String cacheID : caches.keySet()) {
            this.stopCache((Cache)caches.get(cacheID));
        }
        this.cachesTL.set(null);
    }

    protected void stopCache(Cache cache) {
        if (cache != null) {
            try {
                cache.stop();
                cache.destroy();
            }
            catch (Exception e) {
                System.out.println("Exception stopping cache " + e.getMessage());
                e.printStackTrace(System.out);
            }
        }
    }

    private BuddyReplicationConfig getBuddyConfig() throws Exception {
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        brc.setEnabled(true);
        brc.setAutoDataGravitation(false);
        return brc;
    }
}

