/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyFqnTransformer;
import org.jboss.cache.buddyreplication.BuddyReplicationTestsBase;
import org.jboss.cache.util.CachePrinter;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional", "jgroups"})
public class BuddyGroupAssignmentTest
extends BuddyReplicationTestsBase {
    private Log log = LogFactory.getLog(BuddyGroupAssignmentTest.class);
    BuddyFqnTransformer fqnTransformer = new BuddyFqnTransformer();

    public void testSingleBuddy() throws Exception {
        this.log.debug((Object)"Running testSingleBuddy");
        List<CacheSPI<Object, Object>> caches = this.createCaches(3, false);
        this.cachesTL.set(caches);
        System.out.println("*** Testing cache 0:");
        this.assertIsBuddy((Cache)caches.get(0), (Cache)caches.get(1), true);
        System.out.println("*** Testing cache 1:");
        this.assertIsBuddy((Cache)caches.get(1), (Cache)caches.get(2), true);
        System.out.println("*** Testing cache 2:");
        this.assertIsBuddy((Cache)caches.get(2), (Cache)caches.get(0), true);
        System.out.println("Cache 0 = " + CachePrinter.printCacheLockingInfo((Cache)((Cache)caches.get(0))));
        System.out.println("Cache 1 = " + CachePrinter.printCacheLockingInfo((Cache)((Cache)caches.get(1))));
        System.out.println("Cache 2 = " + CachePrinter.printCacheLockingInfo((Cache)((Cache)caches.get(2))));
    }

    public void test2Buddies() throws Exception {
        this.log.debug((Object)"Running test2Buddies");
        List<CacheSPI<Object, Object>> caches = this.createCaches(2, 3, false);
        this.cachesTL.set(caches);
        TestingUtil.blockUntilViewsReceived(5000L, caches.toArray(new Cache[0]));
        System.out.println("*** Testing cache 0");
        this.assertIsBuddy((Cache)caches.get(0), (Cache)caches.get(1), false);
        this.assertIsBuddy((Cache)caches.get(0), (Cache)caches.get(2), false);
        System.out.println("*** Testing cache 1");
        this.assertIsBuddy((Cache)caches.get(1), (Cache)caches.get(2), false);
        this.assertIsBuddy((Cache)caches.get(1), (Cache)caches.get(0), false);
        System.out.println("*** Testing cache 2");
        this.assertIsBuddy((Cache)caches.get(2), (Cache)caches.get(1), false);
        this.assertIsBuddy((Cache)caches.get(2), (Cache)caches.get(0), false);
    }

    public void testRemovalFromClusterSingleBuddy() throws Exception {
        this.log.debug((Object)"Running testRemovalFromClusterSingleBuddy");
        List<CacheSPI<Object, Object>> caches = this.createCaches(3, false);
        this.cachesTL.set(caches);
        System.out.println("*** Testing cache 0");
        this.assertIsBuddy((Cache)caches.get(0), (Cache)caches.get(1), true);
        System.out.println("*** Testing cache 1");
        this.assertIsBuddy((Cache)caches.get(1), (Cache)caches.get(2), true);
        System.out.println("*** Testing cache 2");
        this.assertIsBuddy((Cache)caches.get(2), (Cache)caches.get(0), true);
        caches.get(1).stop();
        caches.set(1, null);
        TestingUtil.sleepThread(this.getSleepTimeout());
        System.out.println("*** Testing cache 0");
        this.assertIsBuddy((Cache)caches.get(0), (Cache)caches.get(2), true);
        System.out.println("*** Testing cache 2");
        this.assertIsBuddy((Cache)caches.get(2), (Cache)caches.get(0), true);
        System.out.println("*** Completed successfully ***");
        this.assertNoLocks(caches);
    }

    public void testRemovalFromCluster2Buddies() throws Exception {
        this.log.debug((Object)"Running testRemovalFromCluster2Buddies");
        List<CacheSPI<Object, Object>> caches = this.createCaches(2, 4, false);
        this.cachesTL.set(caches);
        this.assertNoLocks(caches);
        System.out.println("*** Testing cache 0");
        this.assertIsBuddy((Cache)caches.get(0), (Cache)caches.get(1), false);
        this.assertIsBuddy((Cache)caches.get(0), (Cache)caches.get(2), false);
        System.out.println("*** Testing cache 1");
        this.assertIsBuddy((Cache)caches.get(1), (Cache)caches.get(2), false);
        this.assertIsBuddy((Cache)caches.get(1), (Cache)caches.get(3), false);
        System.out.println("*** Testing cache 2");
        this.assertIsBuddy((Cache)caches.get(2), (Cache)caches.get(3), false);
        this.assertIsBuddy((Cache)caches.get(2), (Cache)caches.get(0), false);
        System.out.println("*** Testing cache 3");
        this.assertIsBuddy((Cache)caches.get(3), (Cache)caches.get(0), false);
        this.assertIsBuddy((Cache)caches.get(3), (Cache)caches.get(1), false);
        caches.get(1).stop();
        caches.set(1, null);
        TestingUtil.sleepThread(this.getSleepTimeout());
        System.out.println("*** Testing cache 0");
        this.assertIsBuddy((Cache)caches.get(0), (Cache)caches.get(2), false);
        this.assertIsBuddy((Cache)caches.get(0), (Cache)caches.get(3), false);
        System.out.println("*** Testing cache 2");
        this.assertIsBuddy((Cache)caches.get(2), (Cache)caches.get(3), false);
        this.assertIsBuddy((Cache)caches.get(2), (Cache)caches.get(0), false);
        System.out.println("*** Testing cache 3");
        this.assertIsBuddy((Cache)caches.get(3), (Cache)caches.get(0), false);
        this.assertIsBuddy((Cache)caches.get(3), (Cache)caches.get(2), false);
        this.assertNoLocks(caches);
    }

    public void testAddingNewCaches() throws Exception {
        this.log.debug((Object)"Running testAddingNewCaches");
        List<CacheSPI<Object, Object>> caches = this.createCaches(2, false);
        this.cachesTL.set(caches);
        caches.get(0).put("/cache0", (Object)"k", (Object)"v");
        caches.get(1).put("/cache1", (Object)"k", (Object)"v");
        System.out.println("*** Testing cache 0:");
        this.assertIsBuddy((Cache)caches.get(0), (Cache)caches.get(1), true);
        System.out.println("*** Testing cache 1:");
        this.assertIsBuddy((Cache)caches.get(1), (Cache)caches.get(0), true);
        assert (caches.get(0).peek(this.fqnTransformer.getBackupRoot(caches.get(0).getLocalAddress()), false) == null) : "Should not have backup region for self";
        assert (caches.get(0).peek(this.fqnTransformer.getBackupRoot(caches.get(1).getLocalAddress()), false) != null) : "Should have backup region for buddy";
        assert (caches.get(1).peek(this.fqnTransformer.getBackupRoot(caches.get(0).getLocalAddress()), false) != null) : "Should have backup region for buddy";
        assert (caches.get(1).peek(this.fqnTransformer.getBackupRoot(caches.get(1).getLocalAddress()), false) == null) : "Should not have backup region for self";
        caches.add(this.createCache(1, null));
        TestingUtil.blockUntilViewsReceived(60000, caches);
        System.out.println("*** Testing cache 0:");
        this.assertIsBuddy((Cache)caches.get(0), (Cache)caches.get(1), true);
        System.out.println("*** Testing cache 1:");
        this.assertIsBuddy((Cache)caches.get(1), (Cache)caches.get(2), true);
        System.out.println("*** Testing cache 2:");
        this.assertIsBuddy((Cache)caches.get(2), (Cache)caches.get(0), true);
        System.out.println("0 Lock info: " + CachePrinter.printCacheLockingInfo((Cache)((Cache)caches.get(0))));
        System.out.println("1 Lock info: " + CachePrinter.printCacheLockingInfo((Cache)((Cache)caches.get(1))));
        System.out.println("2 Lock info: " + CachePrinter.printCacheLockingInfo((Cache)((Cache)caches.get(2))));
        assert (caches.get(0).peek(this.fqnTransformer.getBackupRoot(caches.get(0).getLocalAddress()), false) == null) : "Should not have backup region for self";
        assert (caches.get(0).peek(this.fqnTransformer.getBackupRoot(caches.get(1).getLocalAddress()), false) == null) : "Should have backup region for non-buddy";
        assert (caches.get(0).peek(this.fqnTransformer.getBackupRoot(caches.get(2).getLocalAddress()), false) != null) : "Should have backup region for buddy";
        assert (caches.get(1).peek(this.fqnTransformer.getBackupRoot(caches.get(0).getLocalAddress()), false) != null) : "Should have backup region for buddy";
        assert (caches.get(1).peek(this.fqnTransformer.getBackupRoot(caches.get(1).getLocalAddress()), false) == null) : "Should not have backup region for self";
        assert (caches.get(1).peek(this.fqnTransformer.getBackupRoot(caches.get(2).getLocalAddress()), false) == null) : "Should not have backup region for non-buddy";
        assert (caches.get(2).peek(this.fqnTransformer.getBackupRoot(caches.get(0).getLocalAddress()), false) == null) : "Should not have backup region for non-buddy";
        assert (caches.get(2).peek(this.fqnTransformer.getBackupRoot(caches.get(1).getLocalAddress()), false) != null) : "Should have backup region for buddy";
        assert (caches.get(2).peek(this.fqnTransformer.getBackupRoot(caches.get(2).getLocalAddress()), false) == null) : "Should not have backup region for self";
        assert (caches.get(2).peek(Fqn.fromString((String)"/cache0"), false) == null) : "Unnecessary state should not have been transferred!";
        assert (caches.get(2).peek(Fqn.fromString((String)"/cache1"), false) == null) : "Unnecessary state should not have been transferred!";
        assert (caches.get(2).peek(this.fqnTransformer.getBackupFqn(caches.get(1).getLocalAddress(), Fqn.fromString((String)"/cache1")), false) != null) : "Backup state should have transferred!";
    }
}

