/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.buddyreplication.BuddyReplicationTestsBase;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.util.CachePrinter;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(sequential=true)
public class BuddyReplicationRejoinTest
extends BuddyReplicationTestsBase {
    private static Log log = LogFactory.getLog(BuddyReplicationRejoinTest.class);
    private static final int OBJECT_COUNT = 10;
    private Cache<String, Integer> cache1;
    private Cache<String, Integer> cache2;

    @BeforeMethod
    public void setUp() throws Exception {
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        brc.setEnabled(true);
        brc.setBuddyCommunicationTimeout(1000);
        brc.setAutoDataGravitation(true);
        brc.setDataGravitationRemoveOnFind(true);
        brc.setDataGravitationSearchBackupTrees(true);
        Configuration c = new Configuration();
        c.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        c.setBuddyReplicationConfig(brc);
        this.cache1 = new UnitTestCacheFactory().createCache(c, false);
        this.cache2 = new UnitTestCacheFactory().createCache(c.clone(), false);
    }

    @Override
    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches(this.cache1, this.cache2);
        this.cache1 = null;
        this.cache2 = null;
    }

    public void testGravitationAndFailover() throws CloneNotSupportedException {
        Configuration cfg = this.cache2.getConfiguration().clone();
        this.cache1.start();
        TestingUtil.sleepThread(100L);
        this.addInitial(this.cache1);
        this.printCacheDetails("INITIAL STATES");
        this.cache2.start();
        this.printCacheDetails("CACHE2 STARTED");
        this.runBuddyUpdatesAndFail();
        this.checkRecoveredData(this.cache1, 1);
        this.printCacheDetails("DATA GRAVITATED BACK TO CACHE1");
        this.cache2 = new UnitTestCacheFactory().createCache(cfg);
        this.printCacheDetails("BUDDY BACK");
        this.runBuddyUpdatesAndFail();
        this.checkRecoveredData(this.cache1, 2);
        this.printCacheDetails("DATA GRAVITATED BACK TO CACHE1 (AGAIN)");
    }

    private void runBuddyUpdatesAndFail() {
        this.executeBuddy(this.cache2);
        this.printCacheDetails("BUDDY UPDATED");
        this.cache2.stop();
        this.printCacheDetails("BUDDY FAILED");
    }

    private void executeBuddy(Cache<String, Integer> cache) {
        for (int i = 0; i < 5; ++i) {
            Integer integer = (Integer)cache.get(Fqn.fromString((String)String.valueOf(i)), (Object)"counter");
            cache.put(Fqn.fromString((String)String.valueOf(i)), (Object)"counter", (Object)(integer + 1));
        }
    }

    private void addInitial(Cache<String, Integer> cache) {
        for (int i = 0; i < 10; ++i) {
            cache.put(Fqn.fromElements((Object[])new String[]{String.valueOf(i)}), (Object)"counter", (Object)0);
        }
    }

    private void checkRecoveredData(Cache<String, Integer> cache, int expectedValue) {
        log.info((Object)"*********** RECOVERED DATA ***********");
        for (int i = 0; i < 10; ++i) {
            Integer counter = (Integer)cache.get(Fqn.fromString((String)String.valueOf(i)), (Object)"counter");
            log.info((Object)("/" + i + " counter = " + counter));
            assert (i >= 5 ? counter == 0 : counter == expectedValue);
        }
        log.info((Object)"*********************************");
    }

    private void printCacheDetails(String state) {
        log.info((Object)("*********** " + state + " ***********"));
        if (this.cache1.getCacheStatus() == CacheStatus.STARTED) {
            log.info((Object)("--------- CACHE 1 (" + this.cache1.getLocalAddress() + ") ---------"));
            log.info((Object)CachePrinter.printCacheDetails(this.cache1));
        } else {
            log.info((Object)"--------- CACHE 1 STOPPED");
        }
        if (this.cache2.getCacheStatus() == CacheStatus.STARTED) {
            log.info((Object)("--------- CACHE 2 (" + this.cache2.getLocalAddress() + ") ---------"));
            log.info((Object)(CachePrinter.printCacheDetails(this.cache2) + "\n\n"));
        } else {
            log.info((Object)"--------- CACHE 2 STOPPED");
        }
    }
}

