/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands;

import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class RollbackOnNoOpTest {
    private CacheSPI<Object, Object> cache;
    private TransactionManager txMgr;

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        Configuration cacheConfig = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL, false);
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(cacheConfig, false);
        this.cache.start();
        this.txMgr = this.cache.getTransactionManager();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
        this.txMgr = null;
    }

    public void testRollbackOnRemoveNodeDoesNotFail() throws Exception {
        this.txMgr.begin();
        this.cache.remove("/blah/blah", (Object)"non-exist");
        this.txMgr.rollback();
    }

    public void testRollbackOnClearData() throws Exception {
        this.txMgr.begin();
        this.cache.clearData("/blah/blah");
        this.txMgr.rollback();
    }

    public void testCreateNodeCommand() throws Exception {
        this.cache.put("/blah/blah", (Object)"key", (Object)"value");
        this.txMgr.begin();
        this.cache.clearData("/blah/blah");
        this.txMgr.rollback();
        assert (this.cache.get("/blah/blah", (Object)"key") != null);
    }

    public void testRemoveKeyCommand() throws Exception {
        this.txMgr.begin();
        this.cache.remove("/blah/blah", (Object)"key");
        this.txMgr.rollback();
    }

    public void testRemoveNodeCommand() throws Exception {
        this.cache.put("/blah/blah", (Object)"key", (Object)"value");
        this.txMgr.begin();
        this.cache.removeNode("/blah");
        this.txMgr.rollback();
    }
}

