/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.legacy.write;

import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeNotExistsException;
import org.jboss.cache.commands.legacy.write.PessMoveCommand;
import org.jboss.cache.commands.read.AbstractDataCommandTest;
import org.jboss.cache.commands.write.MoveCommand;
import org.jboss.cache.mock.MockNodesFixture;
import org.jboss.cache.notifications.Notifier;
import org.testng.annotations.Test;

@Test(groups={"unit"}, sequential=true)
public class MoveCommandTest
extends AbstractDataCommandTest {
    MoveCommand command;
    Notifier notifier;
    IMocksControl control;
    MockNodesFixture nodes;
    Fqn source = Fqn.fromString((String)"/source");
    Fqn destination = Fqn.fromString((String)"/destination");

    protected void moreSetup() {
        this.control = EasyMock.createStrictControl();
        this.notifier = (Notifier)this.control.createMock(Notifier.class);
        this.container = (DataContainer)this.control.createMock(DataContainer.class);
        this.command = new PessMoveCommand(this.source, this.destination);
        this.command.initialize(this.notifier, this.container);
        this.nodes = new MockNodesFixture();
    }

    public void testFailsOnMissingSource() {
        this.control.checkOrder(false);
        EasyMock.expect((Object)this.container.peek(this.source)).andReturn(null);
        EasyMock.expect((Object)this.container.peek(this.destination)).andReturn((Object)this.nodes.adfgNode);
        this.control.replay();
        try {
            this.command.perform(this.ctx);
            assert (false) : "should have thrown an exception as the source is null";
        }
        catch (NodeNotExistsException nodeNotExistsException) {
            // empty catch block
        }
    }

    public void testFailsOnMissingDestination() {
        this.control.checkOrder(false);
        EasyMock.expect((Object)this.container.peek(this.source)).andReturn((Object)this.nodes.adfgNode);
        EasyMock.expect((Object)this.container.peek(this.destination)).andReturn(null);
        this.control.replay();
        try {
            this.command.perform(this.ctx);
            assert (false) : "should have thrown an exception as the source is null";
        }
        catch (NodeNotExistsException nodeNotExistsException) {
            // empty catch block
        }
    }
}

