/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.write;

import javax.transaction.TransactionManager;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.commands.read.AbstractDataCommandTest;
import org.jboss.cache.commands.write.InvalidateCommand;
import org.jboss.cache.mock.MockNodesFixture;
import org.jboss.cache.notifications.Notifier;
import org.testng.annotations.Test;

@Test(groups={"unit"}, sequential=true)
public class InvalidateCommandTest
extends AbstractDataCommandTest {
    InvalidateCommand command;
    Notifier notifier;
    IMocksControl control;
    MockNodesFixture nodes;
    TransactionManager tmMock;
    CacheSPI spiMock;

    protected void moreSetup() {
        this.control = EasyMock.createStrictControl();
        this.notifier = (Notifier)this.control.createMock(Notifier.class);
        this.container = (DataContainer)this.control.createMock(DataContainer.class);
        this.tmMock = (TransactionManager)this.control.createMock(TransactionManager.class);
        this.spiMock = (CacheSPI)this.control.createMock(CacheSPI.class);
        this.command = new InvalidateCommand(this.testFqn);
        this.command.initialize(this.spiMock, this.container, this.notifier);
        this.nodes = new MockNodesFixture();
    }

    public void testNullNode() {
        EasyMock.expect((Object)this.spiMock.getNode(this.testFqn)).andReturn(null);
        this.control.replay();
        assert (null == this.command.perform(this.ctx));
        this.control.verify();
    }

    public void testExistingNode() {
        EasyMock.expect((Object)this.spiMock.getNode(this.testFqn)).andReturn((Object)this.nodes.adfNode);
        this.notifier.notifyNodeInvalidated(this.testFqn, true, this.ctx);
        EasyMock.expect((Object)this.container.evict(this.testFqn)).andReturn((Object)Boolean.TRUE);
        this.notifier.notifyNodeInvalidated(this.testFqn, false, this.ctx);
        this.control.replay();
        assert (null == this.command.perform(this.ctx));
        assert (!this.nodes.adfNode.isValid()) : "node should had been invalidated";
        assert (!this.nodes.adfgNode.isValid()) : "child should had been invalidated";
        assert (!this.nodes.adfhNode.isValid()) : "child should had been invalidated";
        this.control.verify();
    }

    public void testRootNodeInvalidation() {
        this.command.setFqn(Fqn.ROOT);
        this.nodes.adfgNode.put("key", "value");
        EasyMock.expect((Object)this.spiMock.getNode(Fqn.ROOT)).andReturn((Object)this.nodes.root);
        this.notifier.notifyNodeInvalidated(Fqn.ROOT, true, this.ctx);
        EasyMock.expect((Object)this.container.evict(Fqn.ROOT)).andReturn((Object)Boolean.TRUE);
        this.notifier.notifyNodeInvalidated(Fqn.ROOT, false, this.ctx);
        this.control.replay();
        assert (null == this.command.perform(this.ctx));
        assert (this.nodes.root.isValid()) : "root should NOT had been invalidated";
        assert (!this.nodes.adfgNode.isValid()) : "node should had been invalidated";
        this.control.verify();
    }

    public void testInvalidateResidentNode() {
        this.nodes.adfNode.setResident(true);
        this.testExistingNode();
    }
}

