/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config.parsing;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.parsing.CacheConfigsXmlParser;
import org.jboss.cache.lock.IsolationLevel;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"unit"})
public class CacheConfigsTest {
    public void testNewFormat() throws CloneNotSupportedException {
        String xml = "<cache-configs>\n   <cache-config name=\"A\">\n      <jbosscache  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n            xmlns=\"urn:jboss:jbosscache-core:config:3.0\">\n         <locking isolationLevel=\"REPEATABLE_READ\" lockAcquisitionTimeout=\"15000\"/>\n         <transaction transactionManagerLookupClass=\"org.jboss.cache.transaction.GenericTransactionManagerLookup\"/>\n         <clustering><stateRetrieval timeout=\"20000\"/></clustering>\n      </jbosscache>\n   </cache-config>\n\n   <cache-config name=\"B\">\n      <jbosscache  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n            xmlns=\"urn:jboss:jbosscache-core:config:3.0\">\n         <locking isolationLevel=\"READ_COMMITTED\" lockAcquisitionTimeout=\"15000\"/>\n         <transaction transactionManagerLookupClass=\"org.jboss.cache.transaction.GenericTransactionManagerLookup\"/>\n         <clustering><stateRetrieval timeout=\"20000\"/></clustering>\n      </jbosscache>\n   </cache-config>\n\n   <cache-config name=\"C\">\n      <jbosscache  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n            xmlns=\"urn:jboss:jbosscache-core:config:3.0\">\n         <locking isolationLevel=\"READ_COMMITTED\" lockAcquisitionTimeout=\"100\"/>\n         <clustering><stateRetrieval timeout=\"100\"/></clustering>\n      </jbosscache>\n   </cache-config>\n</cache-configs>";
        ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
        CacheConfigsXmlParser ccxp = new CacheConfigsXmlParser();
        Map map = ccxp.parseConfigs((InputStream)bais);
        Map<String, Configuration> toExpect = this.buildExpectedValues();
        assert (((Object)map).equals(toExpect)) : "Expected " + toExpect + " but was " + map;
    }

    public void testLegacyFormat() throws CloneNotSupportedException {
        String xml = "<cache-configs>\n   <cache-config name=\"A\">\n      <attribute name=\"IsolationLevel\">REPEATABLE_READ</attribute>\n      <attribute name=\"LockAcquisitionTimeout\">15000</attribute>\n      <attribute name=\"TransactionManagerLookupClass\">org.jboss.cache.transaction.GenericTransactionManagerLookup</attribute>\n      <attribute name=\"StateRetrievalTimeout\">20000</attribute>\n      <attribute name=\"CacheMode\">REPL_SYNC</attribute>   </cache-config>\n\n   <cache-config name=\"B\">\n         <attribute name=\"IsolationLevel\">READ_COMMITTED</attribute>\n         <attribute name=\"LockAcquisitionTimeout\">15000</attribute>\n         <attribute name=\"TransactionManagerLookupClass\">org.jboss.cache.transaction.GenericTransactionManagerLookup</attribute>\n         <attribute name=\"StateRetrievalTimeout\">20000</attribute>\n      <attribute name=\"CacheMode\">REPL_SYNC</attribute>   </cache-config>\n\n   <cache-config name=\"C\">\n         <attribute name=\"IsolationLevel\">READ_COMMITTED</attribute>\n         <attribute name=\"LockAcquisitionTimeout\">100</attribute>\n         <attribute name=\"StateRetrievalTimeout\">100</attribute>\n      <attribute name=\"CacheMode\">REPL_SYNC</attribute>   </cache-config>\n</cache-configs>";
        ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
        CacheConfigsXmlParser ccxp = new CacheConfigsXmlParser();
        Map map = ccxp.parseConfigs((InputStream)bais);
        Map<String, Configuration> toExpect = this.buildExpectedValues();
        assert (((Object)map).equals(toExpect));
    }

    private Map<String, Configuration> buildExpectedValues() {
        HashMap<String, Configuration> map = new HashMap<String, Configuration>(3);
        Configuration cfg = new Configuration();
        map.put("A", cfg);
        cfg.setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        cfg.setLockAcquisitionTimeout(15000L);
        cfg.setTransactionManagerLookupClass("org.jboss.cache.transaction.GenericTransactionManagerLookup");
        cfg.setStateRetrievalTimeout(20000L);
        cfg.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        cfg = new Configuration();
        map.put("B", cfg);
        cfg.setIsolationLevel(IsolationLevel.READ_COMMITTED);
        cfg.setLockAcquisitionTimeout(15000L);
        cfg.setTransactionManagerLookupClass("org.jboss.cache.transaction.GenericTransactionManagerLookup");
        cfg.setStateRetrievalTimeout(20000L);
        cfg.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        cfg = new Configuration();
        map.put("C", cfg);
        cfg.setIsolationLevel(IsolationLevel.READ_COMMITTED);
        cfg.setLockAcquisitionTimeout(100L);
        cfg.setStateRetrievalTimeout(100L);
        cfg.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        return map;
    }
}

