/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.eviction.FIFOQueue;
import org.jboss.cache.eviction.NodeEntry;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class FIFOQueueTest {
    private static final int CAPACITY = 200000;
    private FIFOQueue queue;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.queue = new FIFOQueue();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.queue = null;
    }

    public void testQueue() throws Exception {
        NodeEntry ne;
        for (int i = 0; i < 50000; ++i) {
            NodeEntry ne2 = new NodeEntry("/a/b/c/" + Integer.toString(i));
            this.queue.addNodeEntry(ne2);
        }
        AssertJUnit.assertEquals((String)this.queue.getFirstNodeEntry().getFqn().toString(), (String)"/a/b/c/0");
        AssertJUnit.assertEquals((int)50000, (int)this.queue.getNumberOfNodes());
        AssertJUnit.assertTrue((boolean)this.queue.containsNodeEntry(new NodeEntry("/a/b/c/250")));
        NodeEntry ne27500 = this.queue.getNodeEntry("/a/b/c/27500");
        AssertJUnit.assertEquals((String)"/a/b/c/27500", (String)ne27500.getFqn().toString());
        int k = 0;
        while ((ne = this.queue.getFirstNodeEntry()) != null) {
            AssertJUnit.assertEquals((String)("/a/b/c/" + Integer.toString(k)), (String)ne.getFqn().toString());
            this.queue.removeNodeEntry(ne);
            if (++k != 25000) continue;
        }
        AssertJUnit.assertEquals((String)this.queue.getFirstNodeEntry().getFqn().toString(), (String)"/a/b/c/25000");
        AssertJUnit.assertEquals((int)25000, (int)this.queue.getNumberOfNodes());
        k = 25000;
        while ((ne = this.queue.getFirstNodeEntry()) != null) {
            AssertJUnit.assertEquals((String)ne.getFqn().toString(), (String)("/a/b/c/" + Integer.toString(k)));
            this.queue.removeNodeEntry(ne);
            ++k;
        }
        AssertJUnit.assertEquals((int)0, (int)this.queue.getNumberOfNodes());
        AssertJUnit.assertFalse((boolean)this.queue.containsNodeEntry(new NodeEntry("/a/b/c/27500")));
        AssertJUnit.assertNull((Object)this.queue.getNodeEntry("/a/b/c/27500"));
    }

    public void testGetFirstNodeEntry() throws Exception {
        NodeEntry ne;
        for (int i = 0; i < 50000; ++i) {
            NodeEntry ne2 = new NodeEntry("/a/b/c/" + Integer.toString(i));
            this.queue.addNodeEntry(ne2);
        }
        int count = 0;
        while ((ne = this.queue.getFirstNodeEntry()) != null) {
            AssertJUnit.assertEquals((String)("/a/b/c/" + Integer.toString(count)), (String)ne.getFqn().toString());
            this.queue.removeNodeEntry(ne);
            ++count;
        }
    }

    public void testLargeAddAndRemoval() throws Exception {
        NodeEntry ne;
        int i;
        long begin = System.currentTimeMillis();
        for (i = 0; i < 200000; ++i) {
            this.queue.addNodeEntry(new NodeEntry("/test/" + Integer.toString(i)));
        }
        System.out.println("Took " + (System.currentTimeMillis() - begin) + "ms to add " + 200000 + " entries to queue");
        AssertJUnit.assertEquals((int)200000, (int)this.queue.getNumberOfNodes());
        begin = System.currentTimeMillis();
        for (i = 199999; i >= 0; --i) {
            this.queue.removeNodeEntry(new NodeEntry("/test/" + Integer.toString(i)));
        }
        System.out.println("Took " + (System.currentTimeMillis() - begin) + "ms to remove " + 200000 + " entries to queue");
        AssertJUnit.assertEquals((int)0, (int)this.queue.getNumberOfNodes());
        begin = System.currentTimeMillis();
        for (i = 0; i < 200000; ++i) {
            this.queue.addNodeEntry(new NodeEntry("/test/" + Integer.toString(i)));
        }
        System.out.println("Took " + (System.currentTimeMillis() - begin) + "ms to readd " + 200000 + " entries to queue");
        AssertJUnit.assertEquals((int)200000, (int)this.queue.getNumberOfNodes());
        begin = System.currentTimeMillis();
        while ((ne = this.queue.getFirstNodeEntry()) != null) {
            this.queue.removeNodeEntry(ne);
        }
        System.out.println("Took " + (System.currentTimeMillis() - begin) + "ms to iterate via getFirstNodeEntry() and remove (pop from top of queue) " + 200000 + " entries from queue");
        AssertJUnit.assertEquals((int)0, (int)this.queue.getNumberOfNodes());
    }

    public void testNumElements() throws Exception {
        int i;
        FIFOQueue queue = new FIFOQueue();
        NodeEntry ne = new NodeEntry("/a/b/c");
        ne.setNumberOfElements(50);
        queue.addNodeEntry(ne);
        AssertJUnit.assertEquals((int)50, (int)queue.getNumberOfElements());
        AssertJUnit.assertEquals((int)1, (int)queue.getNumberOfNodes());
        queue.removeNodeEntry(ne);
        AssertJUnit.assertEquals((int)0, (int)queue.getNumberOfElements());
        for (i = 0; i < 10; ++i) {
            ne = new NodeEntry("/a/b/c/" + Integer.toString(i));
            ne.setNumberOfElements(i);
            queue.addNodeEntry(ne);
        }
        AssertJUnit.assertEquals((int)45, (int)queue.getNumberOfElements());
        AssertJUnit.assertEquals((int)10, (int)queue.getNumberOfNodes());
        ne = queue.getNodeEntry("/a/b/c/0");
        AssertJUnit.assertNotNull((Object)ne);
        AssertJUnit.assertEquals((int)0, (int)ne.getNumberOfElements());
        ne.setNumberOfElements(500);
        AssertJUnit.assertEquals((int)545, (int)queue.getNumberOfElements());
        ne = queue.getNodeEntry("/a/b/c/0");
        AssertJUnit.assertEquals((int)500, (int)ne.getNumberOfElements());
        queue.removeNodeEntry(ne);
        AssertJUnit.assertEquals((int)45, (int)queue.getNumberOfElements());
        AssertJUnit.assertEquals((int)9, (int)queue.getNumberOfNodes());
        for (i = 1; i < 10; ++i) {
            ne = queue.getNodeEntry("/a/b/c/" + Integer.toString(i));
            AssertJUnit.assertEquals((int)i, (int)ne.getNumberOfElements());
            queue.removeNodeEntry(ne);
        }
        AssertJUnit.assertEquals((int)0, (int)queue.getNumberOfNodes());
        AssertJUnit.assertEquals((int)0, (int)queue.getNumberOfElements());
        AssertJUnit.assertNull((Object)queue.getNodeEntry("/a/b/c/0"));
        AssertJUnit.assertNull((Object)queue.getFirstNodeEntry());
    }
}

