/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction.minttl;

import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.EvictionAlgorithmConfigBase;
import org.jboss.cache.eviction.FIFOAlgorithmConfig;
import org.jboss.cache.eviction.minttl.MinTTLTestBase;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class FIFOMinTTLTest
extends MinTTLTestBase {
    private Fqn fqn2;
    private Thread busyThread;
    private volatile boolean busyThreadRunning;

    public FIFOMinTTLTest() {
        this.fqn2 = Fqn.fromRelativeElements((Fqn)this.region, (Object[])new String[]{"b"});
        this.busyThreadRunning = true;
    }

    protected EvictionAlgorithmConfigBase getEvictionAlgorithmConfig() {
        this.startBusyThread();
        FIFOAlgorithmConfig cfg = new FIFOAlgorithmConfig();
        cfg.setMaxNodes(1);
        return cfg;
    }

    @AfterMethod
    public void stopBusyThread() {
        this.busyThreadRunning = false;
        try {
            this.busyThread.interrupt();
            this.busyThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void startBusyThread() {
        this.busyThreadRunning = true;
        this.busyThread = new Thread("BusyThread"){

            public void run() {
                try {
                    FIFOMinTTLTest.this.cacheInitialisedLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                while (FIFOMinTTLTest.this.busyThreadRunning) {
                    System.out.println("Busy thread working... ");
                    FIFOMinTTLTest.this.cache.put(FIFOMinTTLTest.this.fqn2, (Object)"k", (Object)"v");
                    TestingUtil.sleepRandom(150);
                }
            }
        };
        this.busyThread.setDaemon(true);
        this.busyThread.start();
    }
}

