/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction.minttl;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.EvictionAlgorithmConfigBase;
import org.jboss.cache.eviction.EvictionTestsBase;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.util.internals.EvictionController;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public abstract class MinTTLTestBase
extends EvictionTestsBase {
    protected Cache<Object, Object> cache;
    protected Fqn region = Fqn.fromString((String)"/test-region");
    protected Fqn fqn = Fqn.fromRelativeElements((Fqn)this.region, (Object[])new String[]{"a"});
    protected volatile CountDownLatch cacheInitialisedLatch;

    protected abstract EvictionAlgorithmConfigBase getEvictionAlgorithmConfig();

    @BeforeMethod
    public void setUp() {
        this.cacheInitialisedLatch = new CountDownLatch(1);
        EvictionAlgorithmConfigBase cfg = this.getEvictionAlgorithmConfig();
        EvictionRegionConfig regionCfg = new EvictionRegionConfig();
        regionCfg.setRegionFqn(this.region);
        regionCfg.setRegionName(this.region.toString());
        regionCfg.setEvictionAlgorithmConfig((EvictionAlgorithmConfig)cfg);
        EvictionConfig ec = new EvictionConfig();
        ec.setWakeupInterval(200L);
        ec.addEvictionRegionConfig(regionCfg);
        this.cache = new UnitTestCacheFactory().createCache(false);
        this.cache.getConfiguration().setEvictionConfig(ec);
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches(this.cache);
        this.cache = null;
    }

    public void testNoMinimumTTL() throws InterruptedException {
        this.cache.start();
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        this.cacheInitialisedLatch.countDown();
        assert (this.cache.get(this.fqn, (Object)"k") != null) : "Node should be in the cache";
        assert (this.waitForEviction(this.cache, 10L, TimeUnit.SECONDS, this.fqn));
        assert (this.cache.get(this.fqn, (Object)"k") == null) : "Node should have been evicted";
    }

    public void testWithMinimumTTL() throws InterruptedException {
        ((EvictionAlgorithmConfigBase)((EvictionRegionConfig)this.cache.getConfiguration().getEvictionConfig().getEvictionRegionConfigs().get(0)).getEvictionAlgorithmConfig()).setMinTimeToLive(500L);
        this.cache.start();
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        this.cacheInitialisedLatch.countDown();
        assert (this.cache.get(this.fqn, (Object)"k") != null) : "Node should be in the cache";
        new EvictionController(this.cache).startEviction();
        assert (this.cache.get(this.fqn, (Object)"k") != null) : "Node should still be in cache due to a minTTL of 3 secs";
        new EvictionController(this.cache).startEviction(true);
        assert (this.waitForEviction(this.cache, 5L, TimeUnit.SECONDS, this.fqn));
        assert (this.cache.get(this.fqn, (Object)"k") == null) : "Node should have been evicted";
    }
}

