/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.Set;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.loader.AbstractCacheLoaderTestBase;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.jboss.cache.transaction.TransactionSetup;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "transaction"}, sequential=true)
public class TxCacheLoaderTest
extends AbstractCacheLoaderTestBase {
    CacheSPI<Object, Object> cache1;
    CacheSPI<Object, Object> cache2;
    private Fqn fqn = Fqn.fromString((String)"/one/two/three");

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        Configuration c1 = new Configuration();
        c1.setCacheMode("repl_sync");
        c1.setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        c1.setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        c1.setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", DummyInMemoryCacheLoader.class.getName(), "", false, false, false));
        this.cache1 = (CacheSPI)new UnitTestCacheFactory().createCache(c1, false);
        this.cache1.create();
        this.cache1.start();
        Configuration c2 = new Configuration();
        c2.setCacheMode("repl_sync");
        c2.setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        c2.setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        c2.setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", DummyInMemoryCacheLoader.class.getName(), "", false, false, false));
        c2.setLockAcquisitionTimeout(2000L);
        this.cache2 = (CacheSPI)new UnitTestCacheFactory().createCache(c2, false);
        this.cache2.create();
        this.cache2.start();
    }

    @AfterMethod(alwaysRun=false)
    public void tearDown() throws Exception {
        this.cache1.removeNode(Fqn.ROOT);
        TestingUtil.killCaches(new Cache[]{this.cache1});
        TestingUtil.killCaches(new Cache[]{this.cache2});
        this.cache1 = null;
        this.cache2 = null;
    }

    public void testTxPutCommit() throws Exception {
        TransactionManager mgr = this.cache1.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        this.cache1.put(this.fqn, (Object)"key1", (Object)"val1");
        this.cache1.put("/one/two/three/four", (Object)"key2", (Object)"val2");
        AssertJUnit.assertNull((Object)this.cache2.get(this.fqn, (Object)"key1"));
        AssertJUnit.assertNull((Object)this.cache2.get("/one/two/three/four", (Object)"key2"));
        mgr.commit();
        AssertJUnit.assertNotNull((Object)this.cache1.getNode(this.fqn).getKeys());
        Set children = this.cache1.getNode("/one").getChildrenNames();
        AssertJUnit.assertEquals((int)1, (int)children.size());
        TestingUtil.sleepThread(2000L);
        AssertJUnit.assertEquals((Object)"val1", (Object)this.cache2.get(this.fqn, (Object)"key1"));
        AssertJUnit.assertEquals((Object)"val2", (Object)this.cache2.get("/one/two/three/four", (Object)"key2"));
    }

    public void testTxPrepareAndRollback() throws Exception {
        final TransactionManager mgr = this.cache1.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        this.cache1.getConfiguration().setLockAcquisitionTimeout(1500L);
        this.cache2.getConfiguration().setLockAcquisitionTimeout(1500L);
        Thread locker = new Thread(){
            Transaction tx2 = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                mgr.begin();
                this.tx2 = mgr.getTransaction();
                TxCacheLoaderTest.this.cache2.put(TxCacheLoaderTest.this.fqn, (Object)"block-key1", (Object)"block-val1");
                TestingUtil.sleepThread(5000L);
                Object var3_1 = null;
                if (this.tx2 == null) return;
                try {
                    mgr.rollback();
                    return;
                }
                catch (SystemException e2) {
                    e2.printStackTrace();
                }
                return;
                {
                    catch (Exception e) {
                        e.printStackTrace();
                        Object var3_2 = null;
                        if (this.tx2 == null) return;
                        try {
                            mgr.rollback();
                            return;
                        }
                        catch (SystemException e2) {
                            e2.printStackTrace();
                        }
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (this.tx2 == null) throw throwable;
                    try {
                        mgr.rollback();
                        throw throwable;
                    }
                    catch (SystemException e2) {
                        e2.printStackTrace();
                    }
                    throw throwable;
                }
            }
        };
        locker.start();
        TestingUtil.sleepThread(1000L);
        this.cache1.put(this.fqn, (Object)"key1", (Object)"val1");
        this.cache1.put("/one/two/three/four", (Object)"key2", (Object)"val2");
        try {
            mgr.commit();
            AssertJUnit.fail((String)"commit() should fail because we cannot acquire the lock on cache2");
        }
        catch (RollbackException rollback) {
            System.out.println("--- TX was rolled back (as expected)");
            AssertJUnit.assertTrue((boolean)true);
        }
        AssertJUnit.assertNull((Object)this.cache1.get(this.fqn, (Object)"key1"));
        AssertJUnit.assertNull((Object)this.cache1.get("/one/two/three/four", (Object)"key1"));
    }

    public void testPutAfterTxCommit() throws Exception {
        TransactionManager mgr = this.cache1.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        this.cache1.put(this.fqn, (Object)"key1", (Object)"val1");
        AssertJUnit.assertTrue((boolean)this.cache1.exists(this.fqn));
        mgr.commit();
        AssertJUnit.assertTrue((boolean)this.cache1.exists(this.fqn));
        this.cache1.put("/a/b/c", null);
        AssertJUnit.assertTrue((boolean)this.cache1.exists("/a/b/c"));
    }

    public void testPutAfterTxRollback() throws Exception {
        TransactionManager mgr = this.cache1.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        this.cache1.put(this.fqn, (Object)"key1", (Object)"val1");
        AssertJUnit.assertTrue((boolean)this.cache1.exists(this.fqn));
        mgr.rollback();
        AssertJUnit.assertFalse((boolean)this.cache1.getCacheLoaderManager().getCacheLoader().exists(this.fqn));
        AssertJUnit.assertFalse((boolean)this.cache1.exists(this.fqn));
        this.cache1.put("/a/b/c", null);
        AssertJUnit.assertTrue((boolean)this.cache1.exists("/a/b/c"));
    }
}

