/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"}, sequential=true)
public class UpgradeLockTest {
    CacheSPI<Object, Object> cache = null;
    UserTransaction tx = null;
    Properties p = null;
    final String FACTORY = "org.jboss.cache.transaction.DummyContextFactory";
    final String NODE1 = "/test";
    final String NODE2 = "/my/test";
    final String KEY = "key";
    final String VAL1 = "val1";
    final String VAL2 = "val2";

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        System.setProperty("java.naming.factory.initial", "org.jboss.cache.transaction.DummyContextFactory");
        DummyTransactionManager.getInstance();
        if (this.p == null) {
            this.p = new Properties();
            this.p.put("java.naming.factory.initial", "org.jboss.cache.transaction.DummyContextFactory");
        }
        this.tx = (UserTransaction)new InitialContext(this.p).lookup("UserTransaction");
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.cache != null) {
            TestingUtil.killCaches(new Cache[]{this.cache});
            this.cache = null;
        }
        TestingUtil.killTransaction((TransactionManager)DummyTransactionManager.getInstance());
        if (this.tx != null) {
            try {
                this.tx.rollback();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.tx = null;
        }
    }

    private CacheSPI<Object, Object> createCache(IsolationLevel level) {
        CacheSPI c = (CacheSPI)new UnitTestCacheFactory().createCache(false);
        c.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        c.getConfiguration().setClusterName("test");
        c.getConfiguration().setStateRetrievalTimeout(10000L);
        c.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.JBossTransactionManagerLookup");
        c.getConfiguration().setLockAcquisitionTimeout(500L);
        c.getConfiguration().setIsolationLevel(level);
        c.create();
        c.start();
        return c;
    }

    public void testUpgradeWithNone() throws Exception {
        this.runTestWithIsolationLevel(IsolationLevel.NONE);
    }

    public void testUpgradeWithReadUncommitted() throws Exception {
        this.runTestWithIsolationLevel(IsolationLevel.READ_UNCOMMITTED);
    }

    public void testUpgradeWithReadCommitted() throws Exception {
        this.runTestWithIsolationLevel(IsolationLevel.READ_COMMITTED);
    }

    public void testUpgradeWithRepeatableRead() throws Exception {
        this.runTestWithIsolationLevel(IsolationLevel.REPEATABLE_READ);
    }

    public void testUpgradeWithSerializable() throws Exception {
        this.runTestWithIsolationLevel(IsolationLevel.SERIALIZABLE);
    }

    public void testIsolationLevelSerializable() throws Exception {
        this._testIsolationLevel(IsolationLevel.SERIALIZABLE);
    }

    public void testIsolationLevelNone() throws Exception {
        this._testIsolationLevel(IsolationLevel.NONE);
    }

    private void _testIsolationLevel(IsolationLevel l) throws Exception {
        this.cache = this.createCache(l);
        this.tx.begin();
        int expected_num_locks = l == IsolationLevel.NONE ? 0 : 2;
        this.cache.put("/test", null);
        AssertJUnit.assertEquals((int)expected_num_locks, (int)this.cache.getNumberOfLocksHeld());
        this.cache.put("/test", null);
        AssertJUnit.assertEquals((int)expected_num_locks, (int)this.cache.getNumberOfLocksHeld());
        this.tx.rollback();
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    private void runTestWithIsolationLevel(IsolationLevel level) throws Exception {
        block2: {
            this.cache = this.createCache(level);
            this.cache.put("/test", (Object)"key", (Object)"val1");
            this.cache.put("/my/test", (Object)"key", (Object)"val1");
            this.tx.begin();
            try {
                AssertJUnit.assertEquals((Object)"val1", (Object)this.cache.get("/test", (Object)"key"));
                AssertJUnit.assertEquals((Object)"val1", (Object)this.cache.get("/my/test", (Object)"key"));
                this.cache.put("/test", (Object)"key", (Object)"val2");
                this.cache.put("/my/test", (Object)"key", (Object)"val2");
                AssertJUnit.assertEquals((Object)"val2", (Object)this.cache.get("/test", (Object)"key"));
                AssertJUnit.assertEquals((Object)"val2", (Object)this.cache.get("/my/test", (Object)"key"));
                this.tx.commit();
            }
            catch (Throwable t) {
                if (this.tx == null) break block2;
                this.tx.rollback();
            }
        }
        AssertJUnit.assertEquals((Object)"val2", (Object)this.cache.get("/test", (Object)"key"));
        AssertJUnit.assertEquals((Object)"val2", (Object)this.cache.get("/my/test", (Object)"key"));
    }
}

