/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.util.ArrayList;
import java.util.List;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional", "jgroups"}, sequential=true)
public class ReplicateToInactiveRegionTest {
    List<CacheSPI<Object, Object>> caches;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.caches = new ArrayList<CacheSPI<Object, Object>>(2);
        this.caches.add(this.createCache());
        this.caches.add(this.createCache());
        TestingUtil.blockUntilViewsReceived(this.caches.toArray(new CacheSPI[0]), 10000L);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches((Cache)this.caches.get(0), (Cache)this.caches.get(1));
        this.caches = null;
    }

    private CacheSPI<Object, Object> createCache() {
        Configuration c = new Configuration();
        c.setCacheMode("REPL_SYNC");
        c.setUseRegionBasedMarshalling(true);
        CacheSPI cache = (CacheSPI)new UnitTestCacheFactory().createCache(c, false);
        cache.start();
        return cache;
    }

    public void testTransferToInactiveRegion() {
        Fqn f = Fqn.fromString((String)"/a/b");
        this.caches.get(0).put(f, (Object)"k", (Object)"v");
        AssertJUnit.assertEquals((Object)"v", (Object)this.caches.get(0).get(f, (Object)"k"));
        AssertJUnit.assertEquals((Object)"v", (Object)this.caches.get(1).get(f, (Object)"k"));
        Region region0 = this.caches.get(0).getRegionManager().getRegion(f, true);
        region0.registerContextClassLoader(this.getClass().getClassLoader());
        AssertJUnit.assertTrue((String)"Should be active by default", (boolean)region0.isActive());
        AssertJUnit.assertTrue((boolean)this.caches.get(0).getRegionManager().getAllRegions(Region.Type.MARSHALLING).contains(region0));
        Region region1 = this.caches.get(1).getRegionManager().getRegion(f, true);
        region1.registerContextClassLoader(this.getClass().getClassLoader());
        AssertJUnit.assertTrue((String)"Should be active by default", (boolean)region1.isActive());
        AssertJUnit.assertTrue((boolean)this.caches.get(1).getRegionManager().getAllRegions(Region.Type.MARSHALLING).contains(region1));
        region1.deactivate();
        AssertJUnit.assertFalse((String)"Should be have deactivated", (boolean)region1.isActive());
        this.caches.get(0).put(f, (Object)"k", (Object)"v2");
        AssertJUnit.assertEquals((Object)"v2", (Object)this.caches.get(0).get(f, (Object)"k"));
        AssertJUnit.assertNull((Object)this.caches.get(1).get(f, (Object)"k"));
    }
}

