/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.mvcc;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.interceptors.MVCCLockingInterceptor;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class MVCCFullStackTest {
    CacheSPI<Object, Object> cache;

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
    }

    public void testDefaultConfiguration() {
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache();
        assert (TestingUtil.findInterceptor(this.cache, MVCCLockingInterceptor.class) != null) : "MVCC interceptor should be in stack";
        assert (this.cache.getConfiguration().getNodeLockingScheme() == Configuration.NodeLockingScheme.MVCC);
    }

    public void testIsolationLevelUpgrade1() {
        this.isoLevelTest(IsolationLevel.NONE, IsolationLevel.READ_COMMITTED);
    }

    public void testIsolationLevelUpgrade2() {
        this.isoLevelTest(IsolationLevel.READ_UNCOMMITTED, IsolationLevel.READ_COMMITTED);
    }

    public void testIsolationLevelDowngrade() {
        this.isoLevelTest(IsolationLevel.SERIALIZABLE, IsolationLevel.REPEATABLE_READ);
    }

    public void testIsolationLevelNoUpgrade1() {
        this.isoLevelTest(IsolationLevel.READ_COMMITTED, IsolationLevel.READ_COMMITTED);
    }

    public void testIsolationLevelNoUpgrade2() {
        this.isoLevelTest(IsolationLevel.REPEATABLE_READ, IsolationLevel.REPEATABLE_READ);
    }

    private void isoLevelTest(IsolationLevel configuredWith, IsolationLevel expected) {
        Configuration c = new Configuration();
        c.setNodeLockingScheme(Configuration.NodeLockingScheme.MVCC);
        c.setIsolationLevel(configuredWith);
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(c);
        assert (this.cache.getConfiguration().getIsolationLevel() == expected) : "Expected to change isolation level from " + configuredWith + " to " + expected + " but was " + this.cache.getConfiguration().getIsolationLevel();
    }
}

