/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.notifications;

import java.util.concurrent.CountDownLatch;
import org.jboss.cache.Cache;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.buddyreplication.BuddyGroup;
import org.jboss.cache.buddyreplication.BuddyReplicationTestsBase;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.notifications.annotation.BuddyGroupChanged;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.ViewChanged;
import org.jboss.cache.notifications.event.BuddyGroupChangedEvent;
import org.jboss.cache.notifications.event.ViewChangedEvent;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class BuddyGroupChangeNotificationTest
extends BuddyReplicationTestsBase {
    Cache c1;
    Cache c2;
    Cache c3;
    Listener listener;
    static CountDownLatch latch1 = new CountDownLatch(1);
    static CountDownLatch latch2 = new CountDownLatch(1);
    static boolean stage2 = false;
    static boolean notificationsReceived = true;

    @BeforeMethod
    public void setUp() throws CloneNotSupportedException {
        UnitTestCacheFactory cf = new UnitTestCacheFactory();
        Configuration conf = new Configuration();
        conf.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        brc.setEnabled(true);
        conf.setBuddyReplicationConfig(brc);
        this.c1 = cf.createCache(conf, false);
        this.c2 = cf.createCache(conf.clone(), false);
        this.c3 = cf.createCache(conf.clone(), false);
        this.c1.start();
        this.c2.start();
        this.c3.start();
        TestingUtil.blockUntilViewsReceived(60000L, this.c1, this.c2, this.c3);
        Cache[] caches = new Cache[]{this.c1, this.c2, this.c3};
        this.listener = new Listener(caches);
        this.c2.addCacheListener((Object)this.listener);
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches(this.c1, this.c2, this.c3);
        this.c1 = null;
        this.c2 = null;
        this.c3 = null;
    }

    @Test(timeOut=60000L)
    public void testChangingGroups() throws InterruptedException {
        this.assertIsBuddy(this.c1, this.c2, true);
        this.assertIsBuddy(this.c2, this.c3, true);
        this.assertIsBuddy(this.c3, this.c1, true);
        this.c3.stop();
        latch1.await();
        this.assertIsBuddy(this.c1, this.c2, true);
        this.assertIsBuddy(this.c2, this.c1, true);
        stage2 = true;
        this.c3.start();
        latch2.await();
        this.assertIsBuddy(this.c1, this.c2, true);
        this.assertIsBuddy(this.c2, this.c3, true);
        this.assertIsBuddy(this.c3, this.c1, true);
        assert (notificationsReceived);
    }

    @CacheListener
    public static class Listener {
        Cache[] caches;
        int numActiveCaches;

        public Listener(Cache[] caches) {
            this.caches = caches;
        }

        @ViewChanged
        public void viewChanged(ViewChangedEvent e) {
            this.numActiveCaches = e.getNewView().getMembers().size();
        }

        @BuddyGroupChanged
        public void buddyChanged(BuddyGroupChangedEvent e) {
            System.out.println("Received event " + e);
            if (!e.isPre()) {
                BuddyGroup bg = e.getBuddyGroup();
                boolean passed = bg.getDataOwner().equals(this.caches[1].getLocalAddress()) && bg.getBuddies().size() == 1 && bg.getBuddies().contains(this.caches[this.numActiveCaches == 3 ? 2 : 0].getLocalAddress());
                boolean bl = notificationsReceived = notificationsReceived && passed;
                if (stage2) {
                    latch2.countDown();
                } else {
                    latch1.countDown();
                }
            }
        }
    }
}

