/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.util.Iterator;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.interceptors.OptimisticCreateIfNotExistsInterceptor;
import org.jboss.cache.interceptors.OptimisticNodeInterceptor;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.loader.SamplePojo;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.optimistic.MockInterceptor;
import org.jboss.cache.optimistic.TestListener;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionContext;
import org.jboss.cache.transaction.TransactionTable;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "optimistic"}, sequential=true)
public class NodeInterceptorGetChildrenNamesTest
extends AbstractOptimisticTestCase {
    TestListener listener;
    CacheSPI<Object, Object> cache;
    MockInterceptor dummy;
    TransactionManager mgr;

    @BeforeMethod
    public void setUp() throws Exception {
        this.listener = new TestListener();
        this.cache = this.createCacheWithListener(this.listener);
        ComponentRegistry cr = TestingUtil.extractComponentRegistry(this.cache);
        OptimisticCreateIfNotExistsInterceptor interceptor = new OptimisticCreateIfNotExistsInterceptor();
        cr.registerComponent((Object)interceptor, OptimisticCreateIfNotExistsInterceptor.class);
        OptimisticNodeInterceptor nodeInterceptor = new OptimisticNodeInterceptor();
        cr.registerComponent((Object)nodeInterceptor, OptimisticNodeInterceptor.class);
        this.dummy = new MockInterceptor();
        cr.registerComponent((Object)this.dummy, MockInterceptor.class);
        interceptor.setNext((CommandInterceptor)nodeInterceptor);
        nodeInterceptor.setNext((CommandInterceptor)this.dummy);
        TestingUtil.replaceInterceptorChain(this.cache, (CommandInterceptor)interceptor);
        this.mgr = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
    }

    public void testTransactionGetNamesMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.setupTransactions(this.cache, tx);
        SamplePojo pojo = new SamplePojo(21, "test");
        this.cache.put("/one/two", (Object)"key1", (Object)pojo);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalledCommand());
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionContext entry = (OptimisticTransactionContext)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        AssertJUnit.assertEquals((int)1, (int)this.cache.getNode("/one").getChildrenNames().size());
        this.mgr.commit();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalledCommand());
        this.mgr.begin();
        Transaction tx2 = this.mgr.getTransaction();
        this.setupTransactions(this.cache, tx2);
        AssertJUnit.assertEquals((int)0, (int)this.cache.getRoot().getChildrenNames().size());
        this.mgr.commit();
    }

    public void testTransactionGetNoNamesMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.setupTransactions(this.cache, tx);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalledCommand());
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionContext entry = (OptimisticTransactionContext)table.get(gtx);
        AssertJUnit.assertEquals((int)0, (int)this.cache.getRoot().getChildrenNames().size());
        this.mgr.commit();
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)0, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalledCommand());
    }

    public void testTransactionGetNamesIteratorMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.setupTransactions(this.cache, tx);
        SamplePojo pojo = new SamplePojo(21, "test");
        this.cache.put("/one/two", (Object)"key1", (Object)pojo);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalledCommand());
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionContext entry = (OptimisticTransactionContext)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        AssertJUnit.assertEquals((int)1, (int)this.cache.getNode("/one").getChildrenNames().size());
        try {
            Iterator it = this.cache.getNode("/one").getChildrenNames().iterator();
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
            AssertJUnit.fail((String)"Should not be allowed to modify elements in the set returned by getChildrenNames()");
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        AssertJUnit.assertEquals((int)1, (int)this.cache.getNode("/one").getChildrenNames().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        this.mgr.commit();
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalledCommand());
    }
}

