/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.options;

import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.Option;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class CacheModeLocalSimpleTest {
    private CacheSPI<Object, Object> cache1;
    private CacheSPI<Object, Object> cache2;
    private Option cacheModeLocal;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        Configuration c = new Configuration();
        c.setCacheMode("REPL_SYNC");
        c.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache1 = (CacheSPI)new UnitTestCacheFactory().createCache(c, false);
        c = new Configuration();
        c.setCacheMode("REPL_SYNC");
        c.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache2 = (CacheSPI)new UnitTestCacheFactory().createCache(c, false);
        this.cacheModeLocal = new Option();
        this.cacheModeLocal.setCacheModeLocal(true);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        TestingUtil.killCaches(new Cache[]{this.cache1, this.cache2});
        this.cache1 = null;
        this.cache2 = null;
    }

    public void testCacheModeLocalWithTx() throws Exception {
        this.doTest(false);
    }

    public void testCacheModeLocalOptimisticWithTx() throws Exception {
        this.doTest(true);
    }

    private void doTest(boolean optimistic) throws Exception {
        if (optimistic) {
            this.cache1.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
            this.cache2.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
            this.cache1.getConfiguration().setSyncCommitPhase(true);
            this.cache1.getConfiguration().setSyncRollbackPhase(true);
            this.cache2.getConfiguration().setSyncCommitPhase(true);
            this.cache2.getConfiguration().setSyncRollbackPhase(true);
        }
        this.cache1.start();
        this.cache2.start();
        TestingUtil.blockUntilViewsReceived(10000L, new Cache[]{this.cache1, this.cache2});
        TransactionManager mgr = this.cache1.getTransactionManager();
        mgr.begin();
        this.cache1.put(Fqn.fromString((String)"/replicate"), (Object)"k", (Object)"v");
        this.cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        this.cache1.put(Fqn.fromString((String)"/not-replicate"), (Object)"k", (Object)"v");
        mgr.commit();
        Thread.sleep(3000L);
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache1.get("/replicate", (Object)"k"));
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache1.get("/not-replicate", (Object)"k"));
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache2.get("/replicate", (Object)"k"));
        AssertJUnit.assertNull((Object)this.cache2.get("/not-replicate", (Object)"k"));
    }
}

