/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.options;

import java.util.HashMap;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class PessimisticSuppressLockingTest {
    private Fqn fqn = Fqn.fromString((String)"/blah");
    private Fqn fqn1 = Fqn.fromString((String)"/blah/1");
    private CacheSPI<String, String> cache;
    private TransactionManager m;

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        Configuration config = new Configuration();
        config.setCacheMode(Configuration.CacheMode.LOCAL);
        config.setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        UnitTestCacheFactory instance = new UnitTestCacheFactory();
        config.setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        this.cache = (CacheSPI)instance.createCache(config);
        this.m = this.cache.getTransactionManager();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        if (this.cache != null) {
            TestingUtil.killCaches(new Cache[]{this.cache});
            this.cache = null;
        }
        this.m = null;
    }

    public void testSuppressionOfWriteLocks() throws Exception {
        TransactionManager m = this.cache.getTransactionManager();
        m.begin();
        AssertJUnit.assertFalse((boolean)this.cache.getInvocationContext().getOptionOverrides().isSuppressLocking());
        this.cache.put(this.fqn, (Object)"x", (Object)"1");
        AssertJUnit.assertFalse((boolean)this.cache.getInvocationContext().getOptionOverrides().isSuppressLocking());
        AssertJUnit.assertEquals((int)2, (int)this.cache.getNumberOfLocksHeld());
        m.commit();
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        this.cache.removeNode(this.fqn);
        m.begin();
        this.cache.getInvocationContext().getOptionOverrides().setSuppressLocking(true);
        AssertJUnit.assertTrue((boolean)this.cache.getInvocationContext().getOptionOverrides().isSuppressLocking());
        this.cache.put(this.fqn, (Object)"x", (Object)"2");
        AssertJUnit.assertFalse((boolean)this.cache.getInvocationContext().getOptionOverrides().isSuppressLocking());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        m.commit();
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        this.cache.removeNode(this.fqn);
        m.begin();
        AssertJUnit.assertFalse((boolean)this.cache.getInvocationContext().getOptionOverrides().isSuppressLocking());
        this.cache.put(this.fqn, (Object)"x", (Object)"3");
        AssertJUnit.assertFalse((boolean)this.cache.getInvocationContext().getOptionOverrides().isSuppressLocking());
        AssertJUnit.assertEquals((int)2, (int)this.cache.getNumberOfLocksHeld());
        m.commit();
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    public void testSuppressionOf2WriteLocks() throws Exception {
        TransactionManager m = this.cache.getTransactionManager();
        m.begin();
        this.cache.put(this.fqn, (Object)"x", (Object)"1");
        AssertJUnit.assertEquals((int)2, (int)this.cache.getNumberOfLocksHeld());
        m.commit();
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        this.cache.removeNode(this.fqn);
        m.begin();
        this.cache.getInvocationContext().getOptionOverrides().setSuppressLocking(true);
        this.cache.put(this.fqn, (Object)"x", (Object)"2");
        this.cache.getInvocationContext().getOptionOverrides().setSuppressLocking(true);
        this.cache.put(this.fqn1, (Object)"y", (Object)"3");
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        m.commit();
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("x", "1");
        m.begin();
        this.cache.getInvocationContext().getOptionOverrides().setSuppressLocking(true);
        this.cache.put(this.fqn, map);
        this.cache.getInvocationContext().getOptionOverrides().setSuppressLocking(true);
        this.cache.put(this.fqn1, map);
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        m.commit();
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        this.cache.removeNode(this.fqn);
        m.begin();
        this.cache.put(this.fqn, (Object)"x", (Object)"3");
        AssertJUnit.assertEquals((int)2, (int)this.cache.getNumberOfLocksHeld());
        m.commit();
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    public void testSuppressionOfReadLocks() throws Exception {
        this.cache.put(this.fqn, (Object)"x", (Object)"y");
        this.m.begin();
        AssertJUnit.assertFalse((boolean)this.cache.getInvocationContext().getOptionOverrides().isSuppressLocking());
        this.cache.get(this.fqn, (Object)"x");
        AssertJUnit.assertFalse((boolean)this.cache.getInvocationContext().getOptionOverrides().isSuppressLocking());
        AssertJUnit.assertEquals((int)2, (int)this.cache.getNumberOfLocksHeld());
        this.m.commit();
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        this.m.begin();
        this.cache.getInvocationContext().getOptionOverrides().setSuppressLocking(true);
        AssertJUnit.assertTrue((boolean)this.cache.getInvocationContext().getOptionOverrides().isSuppressLocking());
        this.cache.get(this.fqn, (Object)"x");
        AssertJUnit.assertFalse((boolean)this.cache.getInvocationContext().getOptionOverrides().isSuppressLocking());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        this.m.commit();
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        this.m.begin();
        AssertJUnit.assertFalse((boolean)this.cache.getInvocationContext().getOptionOverrides().isSuppressLocking());
        this.cache.get(this.fqn, (Object)"x");
        AssertJUnit.assertFalse((boolean)this.cache.getInvocationContext().getOptionOverrides().isSuppressLocking());
        AssertJUnit.assertEquals((int)2, (int)this.cache.getNumberOfLocksHeld());
        this.m.commit();
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    public void testNodeCreation() {
        AssertJUnit.assertNull((Object)this.cache.getRoot().getChild(this.fqn));
        this.cache.getInvocationContext().getOptionOverrides().setSuppressLocking(true);
        this.cache.put(this.fqn, (Object)"x", (Object)"y");
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        AssertJUnit.assertEquals((String)"y", (String)((String)this.cache.getRoot().getChild(this.fqn).get((Object)"x")));
    }
}

