/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.passivation;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.parsing.XmlConfigurationParser;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class ConcurrentPassivationTest {
    private CacheSPI cache;
    private long wakeupIntervalMillis = 0L;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.initCaches();
        this.wakeupIntervalMillis = this.cache.getConfiguration().getEvictionConfig().getWakeupInterval();
        if (this.wakeupIntervalMillis < 0L) {
            AssertJUnit.fail((String)("testEviction(): eviction thread wake up interval is illegal " + this.wakeupIntervalMillis));
        }
    }

    private void initCaches() {
        UnitTestCacheFactory instance = new UnitTestCacheFactory();
        this.cache = (CacheSPI)instance.createCache(new XmlConfigurationParser().parseFile("configs/local-passivation.xml"), false);
        this.cache.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache.getConfiguration().getCacheLoaderConfig().getFirstCacheLoaderConfig().setClassName(DummyInMemoryCacheLoader.class.getName());
        this.cache.start();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
    }

    public void testConcurrentPassivation() throws Exception {
        Fqn base = Fqn.fromElements((Object[])new String[]{"/org/jboss/test/data/concurrent/passivation"});
        for (int i = 0; i < 35000; ++i) {
            this.cache.put(Fqn.fromRelativeElements((Fqn)base, (Object[])new Integer[]{i / 100}), (Object)i, (Object)"value");
        }
        long loopDone = System.currentTimeMillis() + 5L * this.wakeupIntervalMillis;
        System.out.println("Initialised; Loop for " + 5L * this.wakeupIntervalMillis + " millis");
        while (System.currentTimeMillis() < loopDone) {
            for (int i = 0; i < 35000; ++i) {
                Fqn fqn = Fqn.fromRelativeElements((Fqn)base, (Object[])new Integer[]{i / 100});
                AssertJUnit.assertNotNull((String)("Get on Fqn " + fqn + " returned null"), (Object)this.cache.getNode(fqn));
            }
        }
    }
}

