/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.passivation;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.LRUAlgorithmConfig;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.notifications.annotation.NodeActivated;
import org.jboss.cache.notifications.annotation.NodePassivated;
import org.jboss.cache.notifications.event.NodeEvent;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class PassivationActivationCallbacksTestCase {
    private static final Fqn BASE = Fqn.fromString((String)"/base");
    private static final Log log = LogFactory.getLog(PassivationActivationCallbacksTestCase.class);
    private CacheSPI<String, String> cache;
    private CacheLoader loader = null;
    private CacheListener listener = null;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        UnitTestCacheFactory instance = new UnitTestCacheFactory();
        this.cache = (CacheSPI)instance.createCache(false);
        this.cache.getConfiguration().setCacheMode("local");
        this.configureEviction();
        this.configureCacheLoader();
        this.cache.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.SERIALIZABLE);
        this.listener = new CacheListener();
        this.cache.addCacheListener((Object)this.listener);
        this.cache.create();
        this.cache.start();
        this.loader = this.cache.getCacheLoaderManager().getCacheLoader();
    }

    protected void configureCacheLoader() throws Exception {
        CacheLoaderConfig clc = new CacheLoaderConfig();
        clc.setPassivation(true);
        clc.setShared(false);
        clc.setPreload("/");
        CacheLoaderConfig.IndividualCacheLoaderConfig dummyConfig = new CacheLoaderConfig.IndividualCacheLoaderConfig();
        dummyConfig.setAsync(false);
        dummyConfig.setFetchPersistentState(true);
        dummyConfig.setIgnoreModifications(false);
        dummyConfig.setClassName(DummyInMemoryCacheLoader.class.getName());
        clc.addIndividualCacheLoaderConfig(dummyConfig);
        this.cache.getConfiguration().setCacheLoaderConfig(clc);
    }

    protected void configureEviction() throws Exception {
        EvictionConfig ec = new EvictionConfig();
        ec.setWakeupInterval(1000L);
        LRUAlgorithmConfig lru = new LRUAlgorithmConfig();
        lru.setMaxNodes(0);
        lru.setTimeToLive(5000L);
        ec.setDefaultEvictionRegionConfig(new EvictionRegionConfig(Fqn.ROOT, (EvictionAlgorithmConfig)lru));
        lru = new LRUAlgorithmConfig();
        lru.setMaxNodes(0);
        lru.setTimeToLive(1000L);
        ec.addEvictionRegionConfig(new EvictionRegionConfig(BASE, (EvictionAlgorithmConfig)lru));
        this.cache.getConfiguration().setEvictionConfig(ec);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.cache.removeNode(Fqn.ROOT);
        this.loader.remove(Fqn.fromString((String)"/"));
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
    }

    public void testSimpleLifecycle() throws Exception {
        Fqn fqn = Fqn.fromRelativeElements((Fqn)BASE, (Object[])new String[]{"bean1"});
        this.cache.put(fqn, (Object)"bean", (Object)"A bean");
        this.cache.evict(fqn, false);
        AssertJUnit.assertNull((String)"No activation exception", (Object)this.listener.activationException);
        AssertJUnit.assertNull((String)"No passivation exception", (Object)this.listener.passivationException);
        AssertJUnit.assertTrue((boolean)this.listener.passivated.contains(fqn));
        AssertJUnit.assertFalse((boolean)this.listener.activated.contains(fqn));
        Object obj = this.cache.get(fqn, (Object)"bean");
        AssertJUnit.assertEquals((String)"Got bean", (Object)"A bean", (Object)obj);
        if (this.listener.activationException != null) {
            throw this.listener.activationException;
        }
        if (this.listener.passivationException != null) {
            throw this.listener.passivationException;
        }
        AssertJUnit.assertNull((String)"No activation exception", (Object)this.listener.activationException);
        AssertJUnit.assertNull((String)"No passivation exception", (Object)this.listener.passivationException);
        AssertJUnit.assertTrue((boolean)this.listener.activated.contains(fqn));
    }

    @org.jboss.cache.notifications.annotation.CacheListener
    public class CacheListener {
        protected Log log = LogFactory.getLog(CacheListener.class);
        protected Set<Fqn> passivated = new HashSet<Fqn>();
        protected Set<Fqn> activated = new HashSet<Fqn>();
        protected Exception passivationException;
        protected Exception activationException;

        @NodeActivated
        public void nodeActivated(NodeEvent e) {
            if (e.isPre()) {
                return;
            }
            if (!e.getFqn().isChildOrEquals(BASE)) {
                return;
            }
            Object bean = null;
            try {
                bean = PassivationActivationCallbacksTestCase.this.cache.get(e.getFqn(), (Object)"bean");
            }
            catch (CacheException ex) {
                this.log.error((Object)("nodeActivate(): can't retrieve bean instance from: " + e.getFqn() + " with exception: " + (Object)((Object)ex)));
                this.activationException = ex;
                return;
            }
            if (bean == null) {
                this.activationException = new IllegalStateException("nodeActivate(): null bean instance.");
                throw (IllegalStateException)this.activationException;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("nodeActivate(): saw postActivate event on fqn: " + e.getFqn()));
            }
            this.activated.add(e.getFqn());
        }

        @NodePassivated
        public void nodePassivated(NodeEvent e) {
            if (!e.isPre()) {
                return;
            }
            Fqn fqn = e.getFqn();
            if (!fqn.isChildOrEquals(BASE)) {
                return;
            }
            try {
                Object bean = PassivationActivationCallbacksTestCase.this.cache.get(fqn, (Object)"bean");
                if (bean != null) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("nodePassivate(): send prePassivate event on fqn: " + fqn));
                    }
                    this.passivated.add(fqn);
                }
            }
            catch (CacheException ex) {
                this.log.error((Object)("nodePassivate(): can't retrieve bean instance from: " + fqn + " with exception: " + (Object)((Object)ex)));
                this.passivationException = ex;
            }
        }
    }
}

