/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.statetransfer;

import java.io.InputStream;
import java.util.Map;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.factories.annotations.NonVolatile;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.remoting.jgroups.ChannelMessageListener;
import org.jboss.cache.statetransfer.StateTransferTestBase;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, enabled=false)
public class FailedStateTransferTest
extends StateTransferTestBase {
    public void testFailedStateTransfer() throws Exception {
        Map caches = (Map)this.cachesTL.get();
        Configuration c = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_ASYNC);
        c.setReplVersionString(this.getReplicationVersion());
        c.setStateRetrievalTimeout(60000L);
        CacheSPI cache = (CacheSPI)new UnitTestCacheFactory().createCache(c, false);
        caches.put("secretive", cache);
        ComponentRegistry cr = TestingUtil.extractComponentRegistry((Cache)cache);
        cr.registerComponent((Object)new SecretiveStateCacheMessageListener(), ChannelMessageListener.class);
        cache.start();
        c = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_ASYNC);
        c.setReplVersionString(this.getReplicationVersion());
        c.setStateRetrievalTimeout(60000L);
        CacheSPI recipient = (CacheSPI)new UnitTestCacheFactory().createCache(c, false);
        caches.put("secretive2", recipient);
        cr = TestingUtil.extractComponentRegistry((Cache)recipient);
        cr.registerComponent((Object)new SecretiveStateCacheMessageListener(), ChannelMessageListener.class);
        try {
            recipient.start();
            AssertJUnit.fail((String)"start() should throw an exception");
        }
        catch (CacheException good) {
            // empty catch block
        }
    }

    protected String getReplicationVersion() {
        return "3.0.0.CR4";
    }

    @NonVolatile
    private static class SecretiveStateCacheMessageListener
    extends ChannelMessageListener {
        private SecretiveStateCacheMessageListener() {
        }

        public void setState(byte[] new_state) {
            this.setStateException = new TimeoutException("Planned Timeout");
        }

        public void setState(InputStream istream) {
            this.setStateException = new TimeoutException("Planned Timeout");
        }

        public void setState(String state_id, byte[] state) {
            this.setStateException = new TimeoutException("Planned Timeout");
        }

        public void setState(String state_id, InputStream istream) {
            this.setStateException = new TimeoutException("Planned Timeout");
        }
    }
}

