/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.statetransfer;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, enabled=false, description="Disabled because this test depends on JBCACHE-315 being resolved.")
public class StateTransferUnderLoadTest {
    Cache<Object, Object> cache1;
    Cache<Object, Object> cache2;
    Properties p = null;
    static final String FACTORY = "org.jboss.cache.transaction.DummyContextFactory";

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        System.setProperty("java.naming.factory.initial", FACTORY);
        DummyTransactionManager.getInstance();
        if (this.p == null) {
            this.p = new Properties();
            this.p.put("java.naming.factory.initial", FACTORY);
        }
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.cache2 != null) {
            TestingUtil.killCaches(this.cache2);
            this.cache2 = null;
        }
        if (this.cache1 != null) {
            TestingUtil.killCaches(this.cache1);
            this.cache1 = null;
        }
        TestingUtil.killTransaction((TransactionManager)DummyTransactionManager.getInstance());
    }

    public void testStateTransferDeadlocksPessimistic() throws Exception {
        this.runTest(false);
    }

    public void testStateTransferDeadlocksOptimistic() throws Exception {
        this.runTest(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(boolean optimistic) throws Exception {
        Configuration cfg1 = new Configuration();
        Configuration cfg2 = new Configuration();
        cfg1.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        cfg2.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        if (optimistic) {
            cfg1.setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
            cfg2.setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        }
        cfg1.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        cfg2.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache1 = new UnitTestCacheFactory().createCache(cfg1, true);
        this.cache2 = new UnitTestCacheFactory().createCache(cfg2, false);
        UserTransaction tx1 = (UserTransaction)new InitialContext(this.p).lookup("UserTransaction");
        Writer writer = new Writer(this.cache1, tx1);
        try {
            writer.start();
            this.cache2.create();
            for (int i = 0; i < 100; ++i) {
                this.cache2.start();
                int num_nodes = ((CacheSPI)this.cache2).getNumberOfNodes();
                AssertJUnit.assertTrue((num_nodes >= 1 ? 1 : 0) != 0);
                TestingUtil.sleepThread(100L);
                this.cache2.stop();
            }
            Object var9_8 = null;
            writer.stop();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            writer.stop();
            throw throwable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Writer
    implements Runnable {
        Thread thread;
        Cache<Object, Object> cache;
        boolean running = false;
        UserTransaction tx;

        public Writer(Cache<Object, Object> cache, UserTransaction tx) {
            this.cache = cache;
            this.tx = tx;
        }

        public void start() {
            this.thread = new Thread((Runnable)this, "cache writer");
            this.running = true;
            this.thread.start();
        }

        public void stop() {
            this.running = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Fqn fqn = Fqn.fromString((String)"/a/b/c");
            while (this.running) {
                Object var5_4;
                try {
                    try {
                        this.tx.begin();
                        this.cache.put(fqn, (Object)"key", (Object)"value");
                        this.tx.commit();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        try {
                            this.tx.rollback();
                        }
                        catch (SystemException systemException) {
                        }
                        var5_4 = null;
                        TestingUtil.sleepRandom(100);
                        continue;
                    }
                    var5_4 = null;
                }
                catch (Throwable throwable) {
                    var5_4 = null;
                    TestingUtil.sleepRandom(100);
                    throw throwable;
                }
                TestingUtil.sleepRandom(100);
            }
            return;
        }
    }
}

