/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction.pessimistic;

import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.interceptors.OrderedSynchronizationHandler;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.jboss.cache.transaction.NotifyingTransactionManager;
import org.jboss.cache.transaction.TransactionContext;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class AbortionTest {
    private CacheSPI cache1;
    private CacheSPI cache2;
    private CacheSPI cache3;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache1 = this.initCache(false);
        TestingUtil.sleepThread(1500L);
        this.cache2 = this.initCache(false);
        this.cache3 = this.initCache(true);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(new Cache[]{this.cache3, this.cache2, this.cache1});
        this.cache1 = null;
        this.cache2 = null;
        this.cache3 = null;
    }

    private CacheSPI initCache(boolean notifying) throws Exception {
        Configuration conf = new Configuration();
        conf.setCacheMode("REPL_SYNC");
        conf.setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        conf.setClusterConfig(this.getJGroupsStack());
        conf.setFetchInMemoryState(false);
        CacheSPI c = (CacheSPI)new UnitTestCacheFactory().createCache(conf, false);
        if (!notifying) {
            c.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        } else {
            c.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.NotifyingTransactionManager");
        }
        c.start();
        return c;
    }

    private String getJGroupsStack() throws Exception {
        return UnitTestCacheConfigurationFactory.getClusterConfigFromProperties("udp.xml");
    }

    private void destroyCache(CacheSPI c) {
        if (c != null) {
            c.stop();
            c.destroy();
        }
    }

    public void testSyncCaches() throws Exception {
        this.performTest(false, false);
    }

    public void testSyncCachesSyncCommitRollback() throws Exception {
        this.performTest(true, false);
    }

    public void testAbortBeforeCompletion() throws Exception {
        this.performTest(true, true);
    }

    private void performTest(boolean syncCommitRollback, boolean abortBeforeCompletion) throws Exception {
        this.cache1.getConfiguration().setSyncCommitPhase(syncCommitRollback);
        this.cache1.getConfiguration().setSyncRollbackPhase(syncCommitRollback);
        this.cache2.getConfiguration().setSyncCommitPhase(syncCommitRollback);
        this.cache2.getConfiguration().setSyncRollbackPhase(syncCommitRollback);
        this.cache3.getConfiguration().setSyncCommitPhase(syncCommitRollback);
        this.cache3.getConfiguration().setSyncRollbackPhase(syncCommitRollback);
        TransactionManager mgr1 = this.cache1.getTransactionManager();
        TransactionManager mgr2 = this.cache2.getTransactionManager();
        AssertJUnit.assertTrue((boolean)(this.cache3.getTransactionManager() instanceof NotifyingTransactionManager));
        NotifyingTransactionManager mgr3 = (NotifyingTransactionManager)this.cache3.getTransactionManager();
        mgr3.setCache(this.cache3);
        AssertJUnit.assertSame((Object)mgr1, (Object)mgr2);
        AssertJUnit.assertNotSame((Object)mgr1, (Object)((Object)mgr3));
        AssertJUnit.assertNotSame((Object)mgr2, (Object)((Object)mgr3));
        AssertJUnit.assertTrue((boolean)(mgr1 instanceof DummyTransactionManager));
        AssertJUnit.assertTrue((boolean)(mgr2 instanceof DummyTransactionManager));
        this.cache1.put("/test", (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.get("/test", (Object)"key"));
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get("/test", (Object)"key"));
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache3.get("/test", (Object)"key"));
        mgr3.setNotification(new TestNotification(abortBeforeCompletion));
        mgr1.begin();
        this.cache1.put("/test", (Object)"key", (Object)"value2");
        mgr1.commit();
        TestingUtil.sleepThread(5000L);
        AssertJUnit.assertEquals((int)0, (int)this.cache1.getNumberOfLocksHeld());
        AssertJUnit.assertEquals((int)0, (int)this.cache2.getNumberOfLocksHeld());
        AssertJUnit.assertEquals((String)"put in transaction should NOT have been rolled back", (Object)"value2", (Object)this.cache1.get("/test", (Object)"key"));
        AssertJUnit.assertEquals((String)"put in transaction should NOT have been rolled back", (Object)"value2", (Object)this.cache2.get("/test", (Object)"key"));
    }

    class TestNotification
    implements NotifyingTransactionManager.Notification {
        boolean abortBeforeCompletion;

        public TestNotification(boolean abortBeforeCompletion) {
            this.abortBeforeCompletion = abortBeforeCompletion;
        }

        public void notify(Transaction tx, TransactionContext transactionContext) throws SystemException, RollbackException {
            OrderedSynchronizationHandler osh = transactionContext.getOrderedSynchronizationHandler();
            final Transaction finalTx = tx;
            System.out.println("Notify called.");
            Synchronization abort = new Synchronization(){

                public void beforeCompletion() {
                    if (TestNotification.this.abortBeforeCompletion) {
                        AbortionTest.this.cache3.getConfiguration().getRuntimeConfig().getChannel().close();
                        System.out.println("Returning from abort.beforeCompletion");
                        try {
                            finalTx.setRollbackOnly();
                        }
                        catch (SystemException e) {
                            throw new RuntimeException("Unable to set rollback", e);
                        }
                        throw new RuntimeException("Dummy exception");
                    }
                }

                public void afterCompletion(int i) {
                    if (!TestNotification.this.abortBeforeCompletion) {
                        AbortionTest.this.cache3.getConfiguration().getRuntimeConfig().getChannel().close();
                        System.out.println("Returning from abort.afterCompletion");
                        throw new RuntimeException("Dummy exception");
                    }
                }
            };
            osh.registerAtHead(abort);
            System.out.println("Added sync handler.");
        }
    }
}

