/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.NodeNotExistsException;
import org.jboss.cache.Region;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jgroups.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public interface Cache<K, V> {
    public Configuration getConfiguration();

    public Node<K, V> getRoot();

    public void addCacheListener(Object var1);

    public void removeCacheListener(Object var1);

    public Set<Object> getCacheListeners();

    public V put(Fqn var1, K var2, V var3);

    public V put(String var1, K var2, V var3);

    public void putForExternalRead(Fqn var1, K var2, V var3);

    public void put(Fqn var1, Map<? extends K, ? extends V> var2);

    public void put(String var1, Map<? extends K, ? extends V> var2);

    public V remove(Fqn var1, K var2);

    public V remove(String var1, K var2);

    public boolean removeNode(Fqn var1);

    public boolean removeNode(String var1);

    public Node<K, V> getNode(Fqn var1);

    public Node<K, V> getNode(String var1);

    public V get(Fqn var1, K var2);

    public V get(String var1, K var2);

    public void evict(Fqn var1, boolean var2);

    public void evict(Fqn var1);

    public Region getRegion(Fqn var1, boolean var2);

    public boolean removeRegion(Fqn var1);

    public void create() throws CacheException;

    public void start() throws CacheException;

    public void stop();

    public void destroy();

    public CacheStatus getCacheStatus();

    public InvocationContext getInvocationContext();

    public void setInvocationContext(InvocationContext var1);

    public Address getLocalAddress();

    public List<Address> getMembers();

    public void move(Fqn var1, Fqn var2) throws NodeNotExistsException;

    public void move(String var1, String var2) throws NodeNotExistsException;

    public String getVersion();

    public Map<K, V> getData(Fqn var1);

    public Set<K> getKeys(String var1);

    public Set<K> getKeys(Fqn var1);

    public void clearData(String var1);

    public void clearData(Fqn var1);

    public void startBatch();

    public void endBatch(boolean var1);

    public void addInterceptor(CommandInterceptor var1, int var2);

    public void addInterceptor(CommandInterceptor var1, Class<? extends CommandInterceptor> var2);

    public void removeInterceptor(int var1);

    public void removeInterceptor(Class<? extends CommandInterceptor> var1);
}

