/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.read;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jboss.cache.Fqn;
import org.jboss.cache.InternalNode;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.Visitor;
import org.jboss.cache.commands.read.AbstractDataCommand;
import org.jboss.cache.mvcc.ReadCommittedNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetChildrenNamesCommand
extends AbstractDataCommand {
    public static final int METHOD_ID = 23;

    public GetChildrenNamesCommand() {
    }

    public GetChildrenNamesCommand(Fqn fqn) {
        this.fqn = fqn;
    }

    @Override
    public Object perform(InvocationContext ctx) {
        ReadCommittedNode n = (ReadCommittedNode)(this.fqn == null ? null : ctx.lookUpNode(this.fqn));
        if (n == null || n.isDeleted()) {
            return null;
        }
        ConcurrentMap childrenMap = n.getDelegationTarget().getChildrenMap();
        Set<InternalNode> children = childrenMap.isEmpty() ? Collections.emptySet() : childrenMap.values();
        return this.getCorrectedChildNames(children, ctx);
    }

    private Set<Object> getCorrectedChildNames(Collection<InternalNode> children, InvocationContext ctx) {
        NodeSPI childNode;
        Fqn childFqn;
        HashSet<Object> childNames = new HashSet<Object>();
        for (InternalNode internalNode : children) {
            childFqn = internalNode.getFqn();
            childNode = ctx.lookUpNode(childFqn);
            if (childNode != null && childNode.isDeleted()) continue;
            childNames.add(childFqn.getLastElement());
        }
        for (Map.Entry entry : ctx.getLookedUpNodes().entrySet()) {
            childFqn = (Fqn)entry.getKey();
            if (!childFqn.isDirectChildOf(this.fqn) || !((ReadCommittedNode)(childNode = (ReadCommittedNode)entry.getValue())).isCreated()) continue;
            childNames.add(childFqn.getLastElement());
        }
        return childNames;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitGetChildrenNamesCommand(ctx, this);
    }

    @Override
    public int getCommandId() {
        return 23;
    }
}

