/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.remoting.jgroups;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.NonVolatile;
import org.jboss.cache.io.ExposedByteArrayOutputStream;
import org.jboss.cache.statetransfer.StateTransferManager;
import org.jboss.util.stream.MarshalledValueInputStream;
import org.jboss.util.stream.MarshalledValueOutputStream;
import org.jgroups.ExtendedMessageListener;
import org.jgroups.Message;
import org.jgroups.util.Util;

@NonVolatile
public class ChannelMessageListener
implements ExtendedMessageListener {
    protected volatile Exception setStateException;
    private final Object stateLock = new Object();
    private static final Log log = LogFactory.getLog(ChannelMessageListener.class);
    private static final boolean trace = log.isTraceEnabled();
    private StateTransferManager stateTransferManager;
    private Configuration configuration;
    private volatile boolean isStateSet = false;

    @Inject
    void injectDependencies(StateTransferManager stateTransferManager, Configuration configuration) {
        this.stateTransferManager = stateTransferManager;
        this.configuration = configuration;
    }

    public boolean isStateSet() {
        return this.isStateSet;
    }

    public void setStateSet(boolean stateSet) {
        this.isStateSet = stateSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForState() throws Exception {
        Object object = this.stateLock;
        synchronized (object) {
            while (!this.isStateSet) {
                if (this.setStateException != null) {
                    throw this.setStateException;
                }
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected void stateReceivedSuccess() {
        this.isStateSet = true;
        this.setStateException = null;
    }

    protected void stateReceivingFailed(Throwable t) {
        if (t instanceof CacheException) {
            log.debug((Object)t);
        } else {
            log.error((Object)"failed setting state", t);
        }
        this.setStateException = t instanceof Exception ? (Exception)t : new Exception(t);
    }

    protected void stateProducingFailed(Throwable t) {
        if (t instanceof CacheException) {
            log.debug((Object)t);
        } else {
            log.error((Object)("Caught " + t.getClass().getName() + " while responding to state transfer request"), t);
        }
    }

    public void receive(Message msg) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getState() {
        void var2_6;
        MarshalledValueOutputStream out = null;
        ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream(16384);
        try {
            byte[] result222;
            try {
                out = new MarshalledValueOutputStream((OutputStream)baos);
                this.stateTransferManager.getState((ObjectOutputStream)out, Fqn.ROOT, this.configuration.getStateRetrievalTimeout(), true, true);
            }
            catch (Throwable t) {
                this.stateProducingFailed(t);
                Object var6_4 = null;
                result222 = baos.getRawBuffer();
                Util.close((OutputStream)out);
                return var2_6;
            }
            Object var6_3 = null;
            result222 = baos.getRawBuffer();
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            byte[] result222 = baos.getRawBuffer();
            Util.close((OutputStream)out);
            throw throwable;
        }
        Util.close((OutputStream)out);
        return var2_6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setState(byte[] new_state) {
        if (new_state == null) {
            log.debug((Object)"transferred state is null (may be first member in cluster)");
            return;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(new_state);
        MarshalledValueInputStream in = null;
        try {
            try {
                in = new MarshalledValueInputStream((InputStream)bais);
                this.stateTransferManager.setState((ObjectInputStream)in, Fqn.ROOT);
                this.stateReceivedSuccess();
            }
            catch (Throwable t) {
                this.stateReceivingFailed(t);
                Object var6_5 = null;
                Util.close((InputStream)in);
                Object object2 = this.stateLock;
                synchronized (object2) {
                    this.stateLock.notifyAll();
                    return;
                }
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Util.close((InputStream)in);
            Object object = this.stateLock;
            synchronized (object) {
                this.stateLock.notifyAll();
                throw throwable;
            }
        }
        Util.close((InputStream)in);
        Object object = this.stateLock;
        synchronized (object) {
            this.stateLock.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getState(String state_id) {
        void var4_9;
        boolean hasDifferentSourceAndIntegrationRoots;
        if (trace) {
            log.trace((Object)("Getting state for state id " + state_id));
        }
        MarshalledValueOutputStream out = null;
        String sourceRoot = state_id;
        boolean bl = hasDifferentSourceAndIntegrationRoots = state_id.indexOf("_PARTIAL_STATE_DELIMITER") > 0;
        if (hasDifferentSourceAndIntegrationRoots) {
            sourceRoot = state_id.split("_PARTIAL_STATE_DELIMITER")[0];
        }
        ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream(16384);
        try {
            byte[] result222;
            try {
                out = new MarshalledValueOutputStream((OutputStream)baos);
                this.stateTransferManager.getState((ObjectOutputStream)out, Fqn.fromString(sourceRoot), this.configuration.getStateRetrievalTimeout(), true, true);
            }
            catch (Throwable t) {
                this.stateProducingFailed(t);
                Object var9_7 = null;
                result222 = baos.getRawBuffer();
                Util.close((OutputStream)out);
                return var4_9;
            }
            Object var9_6 = null;
            result222 = baos.getRawBuffer();
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            byte[] result222 = baos.getRawBuffer();
            Util.close((OutputStream)out);
            throw throwable;
        }
        Util.close((OutputStream)out);
        return var4_9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getState(OutputStream ostream) {
        MarshalledValueOutputStream out = null;
        try {
            try {
                out = new MarshalledValueOutputStream(ostream);
                this.stateTransferManager.getState((ObjectOutputStream)out, Fqn.ROOT, this.configuration.getStateRetrievalTimeout(), true, true);
            }
            catch (Throwable t) {
                this.stateProducingFailed(t);
                Object var5_4 = null;
                Util.close((OutputStream)out);
                return;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Util.close((OutputStream)out);
            throw throwable;
        }
        Util.close((OutputStream)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getState(String state_id, OutputStream ostream) {
        boolean hasDifferentSourceAndIntegrationRoots;
        if (trace) {
            log.trace((Object)("Getting state for state id " + state_id));
        }
        String sourceRoot = state_id;
        MarshalledValueOutputStream out = null;
        boolean bl = hasDifferentSourceAndIntegrationRoots = state_id.indexOf("_PARTIAL_STATE_DELIMITER") > 0;
        if (hasDifferentSourceAndIntegrationRoots) {
            sourceRoot = state_id.split("_PARTIAL_STATE_DELIMITER")[0];
        }
        try {
            try {
                out = new MarshalledValueOutputStream(ostream);
                this.stateTransferManager.getState((ObjectOutputStream)out, Fqn.fromString(sourceRoot), this.configuration.getStateRetrievalTimeout(), true, true);
            }
            catch (Throwable t) {
                this.stateProducingFailed(t);
                Object var8_7 = null;
                Util.close((OutputStream)out);
                return;
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            Util.close((OutputStream)out);
            throw throwable;
        }
        Util.close((OutputStream)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setState(InputStream istream) {
        if (istream == null) {
            log.debug((Object)"stream is null (may be first member in cluster)");
            return;
        }
        MarshalledValueInputStream in = null;
        try {
            try {
                in = new MarshalledValueInputStream(istream);
                this.stateTransferManager.setState((ObjectInputStream)in, Fqn.ROOT);
                this.stateReceivedSuccess();
            }
            catch (Throwable t) {
                this.stateReceivingFailed(t);
                Object var5_4 = null;
                Util.close((InputStream)in);
                Object object2 = this.stateLock;
                synchronized (object2) {
                    this.stateLock.notifyAll();
                    return;
                }
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Util.close((InputStream)in);
            Object object = this.stateLock;
            synchronized (object) {
                this.stateLock.notifyAll();
                throw throwable;
            }
        }
        Util.close((InputStream)in);
        Object object = this.stateLock;
        synchronized (object) {
            this.stateLock.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setState(String state_id, byte[] state) {
        boolean hasDifferentSourceAndIntegrationRoots;
        if (trace) {
            log.trace((Object)("Receiving state for " + state_id));
        }
        if (state == null) {
            log.debug((Object)"partial transferred state is null");
            return;
        }
        MarshalledValueInputStream in = null;
        String targetRoot = state_id;
        boolean bl = hasDifferentSourceAndIntegrationRoots = state_id.indexOf("_PARTIAL_STATE_DELIMITER") > 0;
        if (hasDifferentSourceAndIntegrationRoots) {
            targetRoot = state_id.split("_PARTIAL_STATE_DELIMITER")[1];
        }
        try {
            try {
                log.debug((Object)("Setting received partial state for subroot " + state_id));
                Fqn<String> subroot = Fqn.fromString(targetRoot);
                ByteArrayInputStream bais = new ByteArrayInputStream(state);
                in = new MarshalledValueInputStream((InputStream)bais);
                this.stateTransferManager.setState((ObjectInputStream)in, subroot);
                this.stateReceivedSuccess();
            }
            catch (Throwable t) {
                this.stateReceivingFailed(t);
                Object var9_10 = null;
                Util.close(in);
                Object object2 = this.stateLock;
                synchronized (object2) {
                    this.stateLock.notifyAll();
                    return;
                }
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            Util.close(in);
            Object object = this.stateLock;
            synchronized (object) {
                this.stateLock.notifyAll();
                throw throwable;
            }
        }
        Util.close((InputStream)in);
        Object object = this.stateLock;
        synchronized (object) {
            this.stateLock.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setState(String stateId, InputStream istream) {
        boolean hasDifferentSourceAndIntegrationRoots;
        if (trace) {
            log.trace((Object)("Receiving state for " + stateId));
        }
        String targetRoot = stateId;
        MarshalledValueInputStream in = null;
        boolean bl = hasDifferentSourceAndIntegrationRoots = stateId.indexOf("_PARTIAL_STATE_DELIMITER") > 0;
        if (hasDifferentSourceAndIntegrationRoots) {
            targetRoot = stateId.split("_PARTIAL_STATE_DELIMITER")[1];
        }
        if (istream == null) {
            log.debug((Object)"stream is null (may be first member in cluster). State is not set");
            return;
        }
        try {
            try {
                log.debug((Object)("Setting received partial state for subroot " + stateId));
                in = new MarshalledValueInputStream(istream);
                Fqn<String> subroot = Fqn.fromString(targetRoot);
                this.stateTransferManager.setState((ObjectInputStream)in, subroot);
                this.stateReceivedSuccess();
            }
            catch (Throwable t) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Unknown error while integrating state", t);
                }
                this.stateReceivingFailed(t);
                Object var8_9 = null;
                Util.close(in);
                Object object2 = this.stateLock;
                synchronized (object2) {
                    this.stateLock.notifyAll();
                    return;
                }
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            Util.close(in);
            Object object = this.stateLock;
            synchronized (object) {
                this.stateLock.notifyAll();
                throw throwable;
            }
        }
        Util.close((InputStream)in);
        Object object = this.stateLock;
        synchronized (object) {
            this.stateLock.notifyAll();
            return;
        }
    }
}

