/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.cache.pojo;

import static org.testng.AssertJUnit.assertEquals;
import static org.testng.AssertJUnit.assertNotNull;
import static org.testng.AssertJUnit.assertTrue;

import java.util.Properties;

import javax.naming.Context;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.config.Configuration.CacheMode;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.pojo.test.CacheObject;
import org.jboss.cache.pojo.test.Student;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * New NewReplicatedAopTest that doesn't use TreeCacheAopTester.
 *
 * @author Ben Wang
 */

@Test(groups = {"functional"})
public class ReplicatedSerializableTest
{
   Log log_ = LogFactory.getLog(ReplicatedSerializableTest.class);
   PojoCache cache_;
   PojoCache cache1_;


   @BeforeMethod(alwaysRun = true)
   protected void setUp() throws Exception
   {
      Properties prop = new Properties();
      prop.put(Context.INITIAL_CONTEXT_FACTORY, "org.jboss.cache.transaction.DummyContextFactory");
      boolean toStart = false;
      cache_ = PojoCacheFactory.createCache(UnitTestCacheConfigurationFactory.createConfiguration(CacheMode.REPL_SYNC), toStart);
      cache1_ = PojoCacheFactory.createCache(UnitTestCacheConfigurationFactory.createConfiguration(CacheMode.REPL_SYNC), toStart);
      cache_.getCache().getConfiguration().setSyncCommitPhase(true);
      cache1_.getCache().getConfiguration().setSyncCommitPhase(true);
      cache_.start();
      cache1_.start();
   }

   @AfterMethod(alwaysRun = true)
   protected void tearDown() throws Exception
   {
      cache_.stop();
      cache1_.stop();
   }

   public void testSeriazableSubObject() throws Exception
   {
      log_.info("testSerializableSubObject() ....");

      Student ben = new Student();
      ben.setName("Ben");
      ben.setYear("9th grade");
      CacheObject co1 = new CacheObject("1");
      ben.setCO1(co1);
      CacheObject co2 = new CacheObject("2");
      ben.setCO2(co2);

      cache_.attach("/test", ben);

      Student be = (Student) cache1_.find("/test");
      assertNotNull("CacheObject should not be null", be.getCO1());
      assertNotNull("CacheObject should not be null", be.getCO2());
      assertEquals("1", be.getCO1().getId());
      assertEquals("2", be.getCO2().getId());
   }

   /**
    * We don;t currently support Serializable with relationship now.
    *
    * @throws Exception
    */
   @Test(enabled = false)
   public void XtestSeriazableSubObjectRelation() throws Exception
   {
      log_.info("testSerializableSubObjectRelation() ....");

      Student ben = new Student();
      ben.setName("Ben");
      ben.setYear("9th grade");
      CacheObject co1 = new CacheObject("1");
      ben.setCO1(co1);

      Student elynne = new Student();
      elynne.setName("Elynne");
      elynne.setYear("9th grade");
      // Same co object
      elynne.setCO1(co1);

      cache_.attach("/ben", ben);
      cache_.attach("/elynne", elynne);

      Student be = (Student) cache1_.find("/ben");
      Student el = (Student) cache1_.find("/elynne");
      assertNotNull("CacheObject should not be null", be.getCO1());
      assertNotNull("CacheObject should not be null", el.getCO1());
      assertEquals("Both co object should be the same", be.getCO1().getId(), el.getCO1().getId());
      assertTrue("Both co should be the same reference", be.getCO1() == el.getCO1());
   }

   public void testPlainSeriazable() throws Exception
   {
      log_.info("testPlainSerializable() ....");
      // First the flag is set to false
      CacheObject co = new CacheObject("1");
      cache_.attach("/test", co);
      CacheObject co1 = (CacheObject) cache1_.find("/test");
      assertNotNull("co on remote cache should not be null", co1);
      assertEquals("co should be the same", co.getId(), co1.getId());

   }




}
