/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.cache.pojo.rollback;

import static org.testng.AssertJUnit.assertFalse;
import static org.testng.AssertJUnit.assertTrue;

import java.util.ArrayList;

import javax.transaction.TransactionManager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aop.proxy.ClassProxy;
import org.jboss.cache.pojo.PojoCache;
import org.jboss.cache.pojo.PojoCacheFactory;
import org.jboss.cache.pojo.test.Person;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * Additional basic tests
 *
 * @author Ben Wang
 */

@Test(groups = {"functional"})
public class ListUndoTest
{
   Log log_ = LogFactory.getLog(ListUndoTest.class);
   PojoCache cache_;
   TransactionManager tx_mgr;


   @BeforeMethod(alwaysRun = true)
   protected void setUp() throws Exception
   {
      log_.info("setUp() ....");
      String configFile = "META-INF/local-service.xml";
      boolean toStart = false;
      cache_ = PojoCacheFactory.createCache(configFile, toStart);
      cache_.start();
      tx_mgr = DummyTransactionManager.getInstance();

   }

   @AfterMethod(alwaysRun = true)
   protected void tearDown() throws Exception
   {
      cache_.stop();
   }

//   public void testDummy() {}

   public void testSimple() throws Exception
   {
      ArrayList<String> list = new ArrayList<String>();
      list.add("test1");

      try
      {
         tx_mgr.begin();
         cache_.attach("/a", list);
         tx_mgr.rollback();
      }
      catch (Exception e)
      {
      }
      assertFalse("Should not have cache interceptor ", isProxy(list));

      cache_.attach("/a", list);
   }

   public void testSimpleTxWithRollback1() throws Exception
   {
      log_.info("testSimpleTxWithRollback1() ....");
      Person test = new Person();
      test.setName("Ben");
      test.setAge(10);
      ArrayList<String> list = new ArrayList<String>();
      list.add("English");
      test.setLanguages(list);

      try
      {
         tx_mgr.begin();
         cache_.attach("/a", test);
         tx_mgr.rollback();
      }
      catch (Exception e)
      {
      }
      assertFalse("Should not have cache interceptor ", isProxy(test.getLanguages()));

      cache_.attach("/a", test);
   }

   private boolean isProxy(Object pojo)
   {
      if (pojo instanceof ClassProxy) return true;
      return false;
   }

   public void testSimpleTxWithRollback2() throws Exception
   {
      log_.info("testSimpleTxWithRollback1() ....");
      Person test = new Person();
      test.setName("Ben");
      test.setAge(10);
      ArrayList<String> list = new ArrayList<String>();
      list.add("English");
      test.setLanguages(list);

      cache_.attach("/a", test);

      try
      {
         tx_mgr.begin();
         cache_.detach("/a");
         tx_mgr.rollback();
      }
      catch (Exception e)
      {
      }

      assertTrue("Should still have cache interceptor ", isProxy(test.getLanguages()));
      cache_.detach("/a");
   }
}
