/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.pojo.test;

import java.util.ArrayList;
import java.util.List;

/**
 * Usually corresponds to the physical machine that comparises of various devices.
 * <p>This object is used to illustrate the pojo cache capability of PojoCache. Note the absence of <code>Serializable</code>
 * interface.</p>
 *
 * @author <a href="mailto:ben.wang@jboss.com">Ben Wang</a>
 */
// We are using JDK1.5 annotation.
@org.jboss.cache.pojo.annotation.Replicable
public class NetworkNode
{
   String name_;
   List<NetworkElement> elements_;
   String ipAddress_;

   public String getName()
   {
      return name_;
   }

   public void setName(String name)
   {
      name_ = name;
   }

   public List<NetworkElement> getElements()
   {
      return elements_;
   }

   protected void setElements(List<NetworkElement> elements)
   {
      elements_ = elements;
   }

   public void addElement(NetworkElement element)
   {
      if (elements_ == null)
         elements_ = new ArrayList<NetworkElement>();

      elements_.add(element);
      element.setParentNode(this);
   }

   public String getIpAddress()
   {
      return ipAddress_;
   }

   public void setIpAddress(String ipAddress)
   {
      ipAddress_ = ipAddress;
   }

   public String toString()
   {
      StringBuffer sb = new StringBuffer();
      sb.append(" name= ").append(getName()).append(" ipAddress= ").append(getIpAddress());
      sb.append(" elements=").append(getElements());
      return sb.toString();
   }

}
