/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.testng.internal.MethodHelper;
import org.testng.internal.Utils;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailedReporter
extends TestListenerAdapter
implements IReporter {
    public static final String TESTNG_FAILED_XML = "testng-failed.xml";
    private XmlSuite m_xmlSuite;

    public FailedReporter() {
    }

    public FailedReporter(XmlSuite xmlSuite) {
        this.m_xmlSuite = xmlSuite;
    }

    @Override
    public void generateReport(List<XmlSuite> xmlSuites, List<ISuite> suites, String outputDirectory) {
        for (int i = 0; i < xmlSuites.size(); ++i) {
            this.generateFailureSuite(xmlSuites.get(i), suites.get(i), outputDirectory);
        }
    }

    protected void generateFailureSuite(XmlSuite xmlSuite, ISuite suite, String outputDir) {
        XmlSuite failedSuite = (XmlSuite)xmlSuite.clone();
        failedSuite.setName("Failed suite [" + xmlSuite.getName() + "]");
        this.m_xmlSuite = failedSuite;
        HashMap<String, XmlTest> xmlTests = new HashMap<String, XmlTest>();
        for (XmlTest xmlT : xmlSuite.getTests()) {
            xmlTests.put(xmlT.getName(), xmlT);
        }
        Map<String, ISuiteResult> results = suite.getResults();
        for (String name : results.keySet()) {
            ISuiteResult suiteResult = results.get(name);
            ITestContext testContext = suiteResult.getTestContext();
            this.generateXmlTest(suite, (XmlTest)xmlTests.get(testContext.getName()), testContext, testContext.getFailedTests().getAllResults(), testContext.getSkippedTests().getAllResults());
        }
        Utils.writeFile(outputDir, TESTNG_FAILED_XML, failedSuite.toXml());
        Utils.writeFile(suite.getOutputDirectory(), TESTNG_FAILED_XML, failedSuite.toXml());
    }

    @Override
    public void onFinish(ITestContext context) {
    }

    private void generateXmlTest(ISuite suite, XmlTest xmlTest, ITestContext context, Collection<ITestResult> failedTests, Collection<ITestResult> skippedTests) {
        if (skippedTests.size() > 0 || failedTests.size() > 0) {
            HashMap<ITestNGMethod, ITestNGMethod> methodsToReRun = new HashMap<ITestNGMethod, ITestNGMethod>();
            Collection<ITestResult> tests = failedTests.isEmpty() ? skippedTests : failedTests;
            for (ITestResult failedTest : tests) {
                ITestNGMethod current = failedTest.getMethod();
                if (!current.isTest()) continue;
                methodsToReRun.put(current, current);
                ITestNGMethod method = failedTest.getMethod();
                if (!method.isTest()) continue;
                List<ITestNGMethod> methodsDependedUpon = MethodHelper.getMethodsDependedUpon(method, context.getAllTestMethods());
                for (ITestNGMethod m : methodsDependedUpon) {
                    if (!m.isTest()) continue;
                    methodsToReRun.put(m, m);
                }
            }
            ArrayList<ITestNGMethod> result = new ArrayList<ITestNGMethod>();
            for (ITestNGMethod m : context.getAllTestMethods()) {
                if (null == methodsToReRun.get(m)) continue;
                result.add(m);
            }
            methodsToReRun.clear();
            Collection<ITestNGMethod> invoked = suite.getInvokedMethods();
            for (ITestNGMethod tm : invoked) {
                if (tm.isTest()) continue;
                methodsToReRun.put(tm, tm);
            }
            result.addAll(methodsToReRun.keySet());
            this.createXmlTest(context, result, xmlTest);
        }
    }

    private void addMethods(Map<ITestNGMethod, ITestNGMethod> map, ITestNGMethod[] methods) {
        if (null == methods) {
            return;
        }
        for (ITestNGMethod tm : methods) {
            map.put(tm, tm);
        }
    }

    private void createXmlTest(ITestContext context, List<ITestNGMethod> methods, XmlTest srcXmlTest) {
        XmlTest xmlTest = new XmlTest(this.m_xmlSuite);
        xmlTest.setName(context.getName() + "(failed)");
        xmlTest.setAnnotations(srcXmlTest.getAnnotations());
        xmlTest.setBeanShellExpression(srcXmlTest.getExpression());
        xmlTest.setIncludedGroups(srcXmlTest.getIncludedGroups());
        xmlTest.setExcludedGroups(srcXmlTest.getExcludedGroups());
        xmlTest.setParallel(srcXmlTest.isParallel());
        xmlTest.setParameters(srcXmlTest.getParameters());
        List<XmlClass> xmlClasses = this.createXmlClasses(methods);
        xmlTest.setXmlClasses(xmlClasses);
    }

    private List<XmlClass> createXmlClasses(List<ITestNGMethod> methods) {
        ArrayList<XmlClass> result = new ArrayList<XmlClass>();
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        for (ITestNGMethod m : methods) {
            String className = m.getRealClass().getName();
            String method = m.getMethod().getName();
            ArrayList<String> methodList = (ArrayList<String>)map.get(className);
            if (null == methodList) {
                methodList = new ArrayList<String>();
                map.put(className, methodList);
            }
            methodList.add(method);
        }
        for (String className : map.keySet()) {
            List includedMethods = (List)map.get(className);
            XmlClass xmlClass = new XmlClass(className);
            xmlClass.setIncludedMethods(includedMethods);
            result.add(xmlClass);
        }
        return result;
    }

    private String getFileName(ITestContext context) {
        return TESTNG_FAILED_XML;
    }

    private static void ppp(String s) {
        System.out.println("[FailedReporter] " + s);
    }
}

