/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.interceptors;

import java.util.ArrayList;
import java.util.List;
import javax.transaction.Synchronization;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.pojo.PojoCacheException;
import org.jboss.cache.pojo.util.MethodCall;

public class PojoTxSynchronizationHandler
implements Synchronization {
    private static Log log = LogFactory.getLog((String)PojoTxSynchronizationHandler.class.getName());
    private List undoList_ = new ArrayList();
    private static ThreadLocal<PojoTxSynchronizationHandler> handler = new ThreadLocal();

    PojoTxSynchronizationHandler() {
    }

    public static PojoTxSynchronizationHandler current() {
        return handler.get();
    }

    public static PojoTxSynchronizationHandler create() {
        PojoTxSynchronizationHandler current = handler.get();
        if (current == null) {
            current = new PojoTxSynchronizationHandler();
            handler.set(current);
        }
        return current;
    }

    public void beforeCompletion() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void afterCompletion(int status) {
        try {
            switch (status) {
                case 3: {
                    return;
                }
                case 1: 
                case 4: {
                    log.debug((Object)"Running Pojo rollback phase");
                    this.runRollbackPhase();
                    log.debug((Object)"Finished rollback phase");
                    return;
                }
                default: {
                    throw new IllegalStateException("illegal status: " + status);
                }
            }
        }
        finally {
            this.resetUndoOp();
        }
    }

    private void runRollbackPhase() {
        for (int i = this.undoList_.size() - 1; i >= 0; --i) {
            MethodCall mc = (MethodCall)this.undoList_.get(i);
            try {
                mc.invoke();
                continue;
            }
            catch (Throwable t) {
                throw new PojoCacheException("PojoTxSynchronizationHandler.runRollbackPhase(): error: " + t, t);
            }
        }
    }

    public void addToList(MethodCall mc) {
        this.undoList_.add(mc);
    }

    public void resetUndoOp() {
        this.undoList_.clear();
        handler.set(null);
    }
}

