/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.util.internals.ViewChangeListener;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "pessimistic"}, sequential=true, testName="api.CacheSPITest")
public class CacheSPITest {
    private CacheSPI<Object, Object> cache1;
    private CacheSPI<Object, Object> cache2;
    protected Configuration.NodeLockingScheme nodeLockingScheme = Configuration.NodeLockingScheme.PESSIMISTIC;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        Configuration conf1 = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC);
        Configuration conf2 = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC);
        conf1.setNodeLockingScheme(this.nodeLockingScheme);
        conf2.setNodeLockingScheme(this.nodeLockingScheme);
        this.cache1 = (CacheSPI)new UnitTestCacheFactory().createCache(conf1, false);
        this.cache2 = (CacheSPI)new UnitTestCacheFactory().createCache(conf2, false);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.cache1 != null) {
            try {
                this.cache1.stop();
                this.cache1.destroy();
                this.cache1 = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.cache2 != null) {
            try {
                this.cache2.stop();
                this.cache2.destroy();
                this.cache2 = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void testGetMembers() throws Exception {
        this.cache1.start();
        List memb1 = this.cache1.getMembers();
        AssertJUnit.assertEquals((String)"View has one member", (int)1, (int)memb1.size());
        Object coord = memb1.get(0);
        this.cache2.start();
        memb1 = this.cache1.getMembers();
        TestingUtil.blockUntilViewsReceived(5000L, false, new Cache[]{this.cache1, this.cache2});
        List memb2 = this.cache2.getMembers();
        AssertJUnit.assertEquals((String)"View has two members", (int)2, (int)memb1.size());
        AssertJUnit.assertEquals((String)"Both caches have same view", (Object)memb1, (Object)memb2);
        this.cache1.stop();
        TestingUtil.blockUntilViewsReceived(5000L, false, new Cache[]{this.cache2});
        memb2 = this.cache2.getMembers();
        AssertJUnit.assertEquals((String)"View has one member", (int)1, (int)memb2.size());
        AssertJUnit.assertFalse((String)"Coordinator changed", (boolean)coord.equals(memb2.get(0)));
    }

    public void testIsCoordinator() throws Exception {
        Configuration conf1 = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC);
        Configuration conf2 = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC);
        this.cache1.start();
        AssertJUnit.assertTrue((String)"Cache1 is coordinator", (boolean)this.cache1.getRPCManager().isCoordinator());
        this.cache2.start();
        AssertJUnit.assertTrue((String)"Cache1 is still coordinator", (boolean)this.cache1.getRPCManager().isCoordinator());
        AssertJUnit.assertFalse((String)"Cache2 is not coordinator", (boolean)this.cache2.getRPCManager().isCoordinator());
        ViewChangeListener viewChangeListener = new ViewChangeListener((Cache)this.cache2);
        this.cache1.stop();
        assert (viewChangeListener.waitForViewChange(60L, TimeUnit.SECONDS)) : "Should have received a view change!";
        AssertJUnit.assertTrue((String)"Cache2 is coordinator", (boolean)this.cache2.getRPCManager().isCoordinator());
    }
}

