/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api;

import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "jgroups", "pessimistic"}, testName="api.NodeReplicatedMoveTest")
public class NodeReplicatedMoveTest {
    protected ThreadLocal<NodeReplicatedMoveTestTL> threadLocal = new ThreadLocal();
    protected static final Fqn A = Fqn.fromString((String)"/a");
    protected static final Fqn B = Fqn.fromString((String)"/b");
    protected static final Fqn C = Fqn.fromString((String)"/c");
    protected static final Fqn D = Fqn.fromString((String)"/d");
    protected static final Fqn E = Fqn.fromString((String)"/e");
    protected static final Object k = "key";
    protected static final Object vA = "valueA";
    protected static final Object vB = "valueB";
    protected static final Object vC = "valueC";
    protected static final Object vD = "valueD";
    protected static final Object vE = "valueE";
    protected Configuration.NodeLockingScheme nodeLockingScheme = Configuration.NodeLockingScheme.PESSIMISTIC;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        NodeReplicatedMoveTestTL tl = new NodeReplicatedMoveTestTL();
        this.threadLocal.set(tl);
        tl.cache1 = (CacheSPI)new UnitTestCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC), false);
        tl.cache1.getConfiguration().setSyncCommitPhase(true);
        tl.cache1.getConfiguration().setSyncRollbackPhase(true);
        tl.cache1.getConfiguration().setNodeLockingScheme(this.nodeLockingScheme);
        this.configure(tl.cache1.getConfiguration());
        tl.cache1.start();
        tl.tm = tl.cache1.getTransactionManager();
        tl.cache2 = (CacheSPI)new UnitTestCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC), false);
        tl.cache2.getConfiguration().setSyncCommitPhase(true);
        tl.cache2.getConfiguration().setSyncRollbackPhase(true);
        tl.cache2.getConfiguration().setNodeLockingScheme(this.nodeLockingScheme);
        this.configure(tl.cache2.getConfiguration());
        tl.cache2.start();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        NodeReplicatedMoveTestTL tl = this.threadLocal.get();
        TestingUtil.killCaches(new Cache[]{tl.cache1, tl.cache2});
        this.threadLocal.set(null);
    }

    protected void configure(Configuration c) {
    }

    public void testReplicatability() {
        NodeReplicatedMoveTestTL tl = this.threadLocal.get();
        CacheSPI<Object, Object> cache1 = tl.cache1;
        CacheSPI<Object, Object> cache2 = tl.cache2;
        NodeSPI rootNode = tl.cache1.getRoot();
        Node nodeA = rootNode.addChild(A);
        Node nodeB = nodeA.addChild(B);
        nodeA.put(k, vA);
        nodeB.put(k, vB);
        AssertJUnit.assertEquals((Object)vA, (Object)cache1.getRoot().getChild(A).get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)cache1.getRoot().getChild(A).getChild(B).get(k));
        AssertJUnit.assertEquals((Object)vA, (Object)cache2.getRoot().getChild(A).get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)cache2.getRoot().getChild(A).getChild(B).get(k));
        cache1.move(nodeB.getFqn(), Fqn.ROOT);
        AssertJUnit.assertEquals((Object)vA, (Object)cache1.getRoot().getChild(A).get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)cache1.getRoot().getChild(B).get(k));
        AssertJUnit.assertEquals((Object)vA, (Object)cache2.getRoot().getChild(A).get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)cache2.getRoot().getChild(B).get(k));
    }

    public void testInvalidations() throws Exception {
        block4: {
            NodeReplicatedMoveTestTL tl = this.threadLocal.get();
            CacheSPI<Object, Object> cache1 = tl.cache1;
            CacheSPI<Object, Object> cache2 = tl.cache2;
            NodeSPI rootNode = tl.cache1.getRoot();
            cache1.stop();
            cache2.stop();
            cache1.destroy();
            cache2.destroy();
            if (this.isOptimistic()) {
                cache1.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
                cache2.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
            }
            cache1.getConfiguration().setCacheMode(Configuration.CacheMode.INVALIDATION_SYNC);
            cache2.getConfiguration().setCacheMode(Configuration.CacheMode.INVALIDATION_SYNC);
            cache1.start();
            cache2.start();
            Node nodeA = rootNode.addChild(A);
            Node nodeB = nodeA.addChild(B);
            nodeA.put(k, vA);
            nodeB.put(k, vB);
            AssertJUnit.assertEquals((Object)vA, (Object)cache1.getRoot().getChild(A).get(k));
            AssertJUnit.assertEquals((Object)vB, (Object)cache1.getRoot().getChild(A).getChild(B).get(k));
            this.assertInvalidated((Cache)cache2, A, "Should be invalidated");
            this.assertInvalidated((Cache)cache2, Fqn.fromRelativeElements((Fqn)A, (Object[])new Object[]{B.getLastElement()}), "Should be invalidated");
            cache1.move(nodeB.getFqn(), Fqn.ROOT);
            AssertJUnit.assertEquals((Object)vA, (Object)cache1.getRoot().getChild(A).get(k));
            AssertJUnit.assertEquals((Object)vB, (Object)cache1.getRoot().getChild(B).get(k));
            this.assertInvalidated((Cache)cache2, A, "Should be invalidated");
            this.assertInvalidated((Cache)cache2, B, "Should be invalidated");
            cache2.getRoot().addChild(A).put((Object)"k2", (Object)"v2");
            try {
                cache1.move(B, A);
                if (!this.isOptimistic()) assert (false) : "Should throw an exception!";
            }
            catch (Exception expected) {
                if (!this.isOptimistic() || $assertionsDisabled) break block4;
                throw new AssertionError((Object)"Should not have thrown an exception!");
            }
        }
    }

    private void assertInvalidated(Cache cache, Fqn fqn, String msg) {
        assert (cache.getRoot().getChild(fqn) == null) : msg;
        NodeSPI n = ((CacheSPI)cache).peek(fqn, true, true);
        assert (n == null || this.isOptimistic()) : msg;
        assert (!this.isOptimistic() || !n.isValid()) : msg;
    }

    public void testReplTxCommit() throws Exception {
        NodeReplicatedMoveTestTL tl = this.threadLocal.get();
        CacheSPI<Object, Object> cache1 = tl.cache1;
        CacheSPI<Object, Object> cache2 = tl.cache2;
        NodeSPI rootNode = tl.cache1.getRoot();
        Fqn A_B = Fqn.fromRelativeFqn((Fqn)A, (Fqn)B);
        Node nodeA = rootNode.addChild(A);
        Node nodeB = nodeA.addChild(B);
        nodeA.put(k, vA);
        nodeB.put(k, vB);
        AssertJUnit.assertEquals((Object)vA, (Object)cache1.getRoot().getChild(A).get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)cache1.getRoot().getChild(A).getChild(B).get(k));
        AssertJUnit.assertEquals((Object)vA, (Object)cache2.getRoot().getChild(A).get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)cache2.getRoot().getChild(A).getChild(B).get(k));
        tl.tm.begin();
        cache1.move(nodeB.getFqn(), Fqn.ROOT);
        AssertJUnit.assertEquals((Object)vA, (Object)cache1.get(A, k));
        AssertJUnit.assertNull((Object)cache1.get(A_B, k));
        AssertJUnit.assertEquals((Object)vB, (Object)cache1.get(B, k));
        tl.tm.commit();
        AssertJUnit.assertEquals((Object)vA, (Object)cache1.getRoot().getChild(A).get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)cache1.getRoot().getChild(B).get(k));
        AssertJUnit.assertEquals((Object)vA, (Object)cache2.getRoot().getChild(A).get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)cache2.getRoot().getChild(B).get(k));
    }

    public void testReplTxRollback() throws Exception {
        NodeReplicatedMoveTestTL tl = this.threadLocal.get();
        CacheSPI<Object, Object> cache1 = tl.cache1;
        CacheSPI<Object, Object> cache2 = tl.cache2;
        NodeSPI rootNode = tl.cache1.getRoot();
        Node nodeA = rootNode.addChild(A);
        Node nodeB = nodeA.addChild(B);
        nodeA.put(k, vA);
        nodeB.put(k, vB);
        AssertJUnit.assertEquals((Object)vA, (Object)cache1.getRoot().getChild(A).get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)cache1.getRoot().getChild(A).getChild(B).get(k));
        AssertJUnit.assertEquals((Object)vA, (Object)cache2.getRoot().getChild(A).get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)cache2.getRoot().getChild(A).getChild(B).get(k));
        tl.tm.begin();
        cache1.move(nodeB.getFqn(), Fqn.ROOT);
        AssertJUnit.assertEquals((Object)vA, (Object)cache1.get(A, k));
        AssertJUnit.assertEquals((Object)vB, (Object)cache1.get(B, k));
        tl.tm.rollback();
        AssertJUnit.assertEquals((Object)vA, (Object)cache1.getRoot().getChild(A).get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)cache1.getRoot().getChild(A).getChild(B).get(k));
        AssertJUnit.assertEquals((Object)vA, (Object)cache2.getRoot().getChild(A).get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)cache2.getRoot().getChild(A).getChild(B).get(k));
    }

    protected boolean isOptimistic() {
        return this.nodeLockingScheme == Configuration.NodeLockingScheme.OPTIMISTIC;
    }

    private class NodeReplicatedMoveTestTL {
        protected CacheSPI<Object, Object> cache1;
        protected CacheSPI<Object, Object> cache2;
        protected TransactionManager tm;

        private NodeReplicatedMoveTestTL() {
        }
    }
}

