/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api.mvcc.read_committed;

import javax.transaction.TransactionManager;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.api.NodeAPITest;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.interceptors.MVCCLockingInterceptor;
import org.jboss.cache.interceptors.OptimisticNodeInterceptor;
import org.jboss.cache.interceptors.PessimisticLockInterceptor;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.lock.IsolationLevel;
import org.testng.annotations.Test;

@Test(groups={"functional", "mvcc"}, testName="api.mvcc.read_committed.NodeAPIMVCCTest")
public class NodeAPIMVCCTest
extends NodeAPITest {
    protected Configuration.NodeLockingScheme getNodeLockingScheme() {
        return Configuration.NodeLockingScheme.MVCC;
    }

    protected void configure(Configuration c) {
        c.setIsolationLevel(IsolationLevel.READ_COMMITTED);
    }

    protected void assertNodeLockingScheme() {
        CacheSPI cache = (CacheSPI)this.cacheTL.get();
        TransactionManager tm = cache.getTransactionManager();
        assert (cache.getConfiguration().getNodeLockingScheme() == Configuration.NodeLockingScheme.MVCC);
        boolean interceptorChainOK = false;
        for (CommandInterceptor i : cache.getInterceptorChain()) {
            if (i instanceof PessimisticLockInterceptor) assert (false) : "Not an MVCC locking chain!!";
            if (i instanceof OptimisticNodeInterceptor) assert (false) : "Not an MVCC locking chain!!";
            if (!(i instanceof MVCCLockingInterceptor)) continue;
            interceptorChainOK = true;
        }
        assert (interceptorChainOK) : "Not an MVCC locking chain!!";
    }

    public void testLocking() {
    }

    protected void childrenUnderTxCheck() throws Exception {
        CacheSPI cache = (CacheSPI)this.cacheTL.get();
        assert (cache.getNode(this.A_B) != null);
        assert (cache.getNode(this.A_C) != null);
        assert (cache.getInvocationContext().getLocks().contains(A));
        assert (cache.getInvocationContext().getLocks().contains(this.A_B));
        assert (cache.getInvocationContext().getLocks().contains(this.A_C));
    }
}

