/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api.nodevalidity;

import java.util.Properties;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.api.nodevalidity.NodeValidityTestBase;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.jboss.cache.loader.DummySharedInMemoryCacheLoader;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional", "pessimistic"}, testName="api.nodevalidity.InvalidatedPessNodeValidityTest")
public class InvalidatedPessNodeValidityTest
extends NodeValidityTestBase {
    protected ThreadLocal<DummyInMemoryCacheLoader> loaderTL = new ThreadLocal();

    public InvalidatedPessNodeValidityTest() {
        this.invalidation = true;
        this.nodeLockingScheme = Configuration.NodeLockingScheme.PESSIMISTIC;
    }

    @Override
    protected Cache<String, String> createObserver() {
        return this.newCache();
    }

    @Override
    protected Cache<String, String> createModifier() {
        return this.newCache();
    }

    @AfterMethod
    public void emptyCacheLoader() {
        DummySharedInMemoryCacheLoader loader = (DummySharedInMemoryCacheLoader)this.loaderTL.get();
        if (loader != null) {
            loader.wipeBin();
        }
        this.loaderTL.set(null);
    }

    protected Cache<String, String> newCache() {
        UnitTestCacheFactory f = new UnitTestCacheFactory();
        Configuration c = new Configuration();
        c.setCacheMode(Configuration.CacheMode.INVALIDATION_SYNC);
        Cache cache = f.createCache(c, false);
        this.nodeLockingSchemeSpecificSetup(cache.getConfiguration());
        CacheLoaderConfig.IndividualCacheLoaderConfig iclc = new CacheLoaderConfig.IndividualCacheLoaderConfig();
        iclc.setClassName(DummySharedInMemoryCacheLoader.class.getName());
        Properties props = new Properties();
        props.setProperty("bin", "bin-" + Thread.currentThread().getName());
        iclc.setProperties(props);
        CacheLoaderConfig clc = new CacheLoaderConfig();
        clc.addIndividualCacheLoaderConfig(iclc);
        cache.getConfiguration().setCacheLoaderConfig(clc);
        cache.getConfiguration().setFetchInMemoryState(false);
        cache.start();
        CacheSPI spi = (CacheSPI)cache;
        DummyInMemoryCacheLoader loader = (DummyInMemoryCacheLoader)spi.getCacheLoaderManager().getCacheLoader();
        this.loaderTL.set(loader);
        return cache;
    }
}

