/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api.optimistic;

import java.util.List;
import java.util.Set;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.api.NodeAPITest;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.interceptors.OptimisticNodeInterceptor;
import org.jboss.cache.interceptors.PessimisticLockInterceptor;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.testng.annotations.Test;

@Test(groups={"functional", "optimistic"}, testName="api.optimistic.NodeAPIOptimisticTest")
public class NodeAPIOptimisticTest
extends NodeAPITest {
    protected Configuration.NodeLockingScheme getNodeLockingScheme() {
        return Configuration.NodeLockingScheme.OPTIMISTIC;
    }

    protected void assertNodeLockingScheme() {
        CacheSPI cache = (CacheSPI)this.cacheTL.get();
        assert (cache.getConfiguration().getNodeLockingScheme() == Configuration.NodeLockingScheme.OPTIMISTIC);
        boolean interceptorChainOK = false;
        for (CommandInterceptor i : cache.getInterceptorChain()) {
            if (i instanceof PessimisticLockInterceptor) assert (false) : "Not an optimistic locking chain!!";
            if (!(i instanceof OptimisticNodeInterceptor)) continue;
            interceptorChainOK = true;
        }
        assert (interceptorChainOK) : "Not an optimistic locking chain!!";
    }

    protected void childrenUnderTxCheck() throws Exception {
        TransactionWorkspace<Object, Object> w = this.getTransactionWorkspace();
        assert (w.getNodes().size() == 4) : "Should be 4 nodes in the workspace, not " + w.getNodes().size();
        List deltas = ((WorkspaceNode)w.getNodes().get(Fqn.ROOT)).getMergedChildren();
        assert (((Set)deltas.get(0)).size() == 1) : "/ should have 1 child added";
        assert (((Set)deltas.get(1)).size() == 0) : "/ should have 0 children removed";
        deltas = ((WorkspaceNode)w.getNodes().get(A)).getMergedChildren();
        assert (((Set)deltas.get(0)).size() == 2) : "/ should have 2 children added";
        assert (((Set)deltas.get(1)).size() == 0) : "/ should have 0 children removed";
        deltas = ((WorkspaceNode)w.getNodes().get(this.A_B)).getMergedChildren();
        assert (((Set)deltas.get(0)).size() == 0) : "/a/b should have 0 children added";
        assert (((Set)deltas.get(1)).size() == 0) : "/a/b should have 0 children removed";
        deltas = ((WorkspaceNode)w.getNodes().get(this.A_C)).getMergedChildren();
        assert (((Set)deltas.get(0)).size() == 0) : "/a/c should have 0 children added";
        assert (((Set)deltas.get(1)).size() == 0) : "/a/c should have 0 children removed";
    }
}

