/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import java.util.List;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyReplicationTestsBase;
import org.jboss.cache.util.CachePrinter;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="buddyreplication.DisabledStateTransferTest")
public class DisabledStateTransferTest
extends BuddyReplicationTestsBase {
    public void testCachesWithoutStateTransfer() throws Exception {
        Fqn backup;
        List<CacheSPI<Object, Object>> caches = this.createCaches(1, 3, false, false, false, false);
        this.cachesTL.set(caches);
        int cacheNumber = 0;
        for (CacheSPI<Object, Object> c : caches) {
            c.getConfiguration().setFetchInMemoryState(false);
            c.start();
            c.put("/" + cacheNumber++, (Object)"k", (Object)"v");
        }
        TestingUtil.blockUntilViewsReceived(caches.toArray(new CacheSPI[0]), 60000L);
        for (CacheSPI<Object, Object> c : caches) {
            System.out.println("Cache (local address " + c.getLocalAddress() + ") contents: " + CachePrinter.printCacheLockingInfo(c));
        }
        for (int i = 0; i < 3; ++i) {
            boolean backupOlderThanOwner;
            int backupIndex;
            int n = backupIndex = i == 2 ? 0 : i + 1;
            assert (caches.get(i).exists("/" + i)) : "Data should exist on owner (cache #" + i + ")";
            backup = this.fqnTransformer.getBackupFqn(caches.get(i).getLocalAddress(), Fqn.fromString((String)("/" + i)));
            assert (caches.get(backupIndex).exists(backup.getParent())) : "Backup region should have been created on buddy (cache #" + backupIndex + ")";
            boolean backupStatePropagated = caches.get(backupIndex).exists(backup);
            boolean bl = backupOlderThanOwner = backupIndex < i;
            assert (!backupStatePropagated && !backupOlderThanOwner || backupStatePropagated && backupOlderThanOwner) : "Backup state should NOT have been transferred to buddy (cache #" + backupIndex + ")";
        }
        cacheNumber = 0;
        for (CacheSPI<Object, Object> c : caches) {
            c.put("/" + cacheNumber++ + "_NEW", (Object)"k", (Object)"v");
        }
        for (int i = 0; i < 3; ++i) {
            int backupIndex;
            int n = backupIndex = i == 2 ? 0 : i + 1;
            assert (caches.get(i).exists("/" + i + "_NEW")) : "Data should exist on owner (cache #" + i + ")";
            backup = this.fqnTransformer.getBackupFqn(caches.get(i).getLocalAddress(), Fqn.fromString((String)("/" + i + "_NEW")));
            assert (caches.get(backupIndex).exists(backup.getParent())) : "Backup region should have been created on buddy (cache #" + backupIndex + ")";
            assert (caches.get(backupIndex).exists(backup)) : "Backup state should NOT have been transferred to buddy (cache #" + backupIndex + ")";
        }
    }
}

