/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.cache.buddyreplication.NextMemberBuddyLocator;
import org.jboss.cache.buddyreplication.NextMemberBuddyLocatorConfig;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"}, sequential=true, testName="buddyreplication.NextMemberBuddyLocatorTest")
public class NextMemberBuddyLocatorTest {
    private IpAddress dataOwner;
    private List<Address> buddies_localhost;
    private List<Address> buddies_same_host_different_nic;
    private List<Address> buddies_different_hosts;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.buddies_localhost = new LinkedList<Address>();
        this.buddies_same_host_different_nic = new LinkedList<Address>();
        this.buddies_different_hosts = new LinkedList<Address>();
        this.dataOwner = new IpAddress(InetAddress.getByName("localhost"), 1000);
        this.buddies_localhost.add((Address)new IpAddress(InetAddress.getByName("localhost"), 2000));
        this.buddies_localhost.add((Address)new IpAddress(InetAddress.getByName("localhost"), 3000));
        this.buddies_localhost.add((Address)new IpAddress(InetAddress.getByName("localhost"), 4000));
        this.buddies_localhost.add((Address)new IpAddress(InetAddress.getByName("localhost"), 5000));
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface i = en.nextElement();
            Enumeration<InetAddress> en2 = i.getInetAddresses();
            while (en2.hasMoreElements()) {
                InetAddress addr = en2.nextElement();
                if (addr.isLoopbackAddress() || addr instanceof Inet6Address) continue;
                this.buddies_same_host_different_nic.add((Address)new IpAddress(addr, 1000));
            }
        }
        this.buddies_different_hosts.add((Address)new IpAddress(InetAddress.getByName("61.62.63.64"), 1000));
        this.buddies_different_hosts.add((Address)new IpAddress(InetAddress.getByName("81.82.83.84"), 1000));
        this.buddies_different_hosts.add((Address)new IpAddress(InetAddress.getByName("101.102.103.104"), 1000));
        this.buddies_different_hosts.add((Address)new IpAddress(InetAddress.getByName("121.122.123.124"), 1000));
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.buddies_localhost = null;
        this.buddies_same_host_different_nic = null;
        this.buddies_different_hosts = null;
        this.dataOwner = null;
    }

    private List getBuddies(int numBuddies, boolean ignoreColoc, List<Address> candidates) {
        return this.getBuddies(numBuddies, ignoreColoc, candidates, null);
    }

    private List getBuddies(int numBuddies, boolean ignoreColoc, List<Address> candidates, Map<Address, String> buddyPool) {
        NextMemberBuddyLocatorConfig cfg = new NextMemberBuddyLocatorConfig();
        cfg.setIgnoreColocatedBuddies(ignoreColoc);
        cfg.setNumBuddies(numBuddies);
        NextMemberBuddyLocator nmbl = new NextMemberBuddyLocator();
        nmbl.init((BuddyReplicationConfig.BuddyLocatorConfig)cfg);
        return nmbl.locateBuddies(buddyPool, candidates, (Address)this.dataOwner);
    }

    public void testSingleBuddyNoColoc() {
        LinkedList<Address> list = new LinkedList<Address>();
        list.add((Address)this.dataOwner);
        list.add(this.buddies_localhost.get(0));
        list.add(this.buddies_localhost.get(1));
        List results = this.getBuddies(1, false, list);
        AssertJUnit.assertEquals((int)1, (int)results.size());
        AssertJUnit.assertEquals((Object)this.buddies_localhost.get(0), results.get(0));
    }

    public void testThreeBuddiesNoColoc() {
        LinkedList<Address> list = new LinkedList<Address>();
        list.add((Address)this.dataOwner);
        list.add(this.buddies_localhost.get(0));
        list.add(this.buddies_localhost.get(1));
        list.add(this.buddies_localhost.get(2));
        list.add(this.buddies_localhost.get(3));
        List results = this.getBuddies(3, false, list);
        AssertJUnit.assertEquals((int)3, (int)results.size());
        AssertJUnit.assertEquals((Object)this.buddies_localhost.get(0), results.get(0));
        AssertJUnit.assertEquals((Object)this.buddies_localhost.get(1), results.get(1));
        AssertJUnit.assertEquals((Object)this.buddies_localhost.get(2), results.get(2));
    }

    public void testMoreBuddiesThanAvblNoColoc() {
        LinkedList<Address> list = new LinkedList<Address>();
        list.add((Address)this.dataOwner);
        list.add(this.buddies_localhost.get(0));
        list.add(this.buddies_localhost.get(1));
        List results = this.getBuddies(3, false, list);
        AssertJUnit.assertEquals((int)2, (int)results.size());
        AssertJUnit.assertEquals((Object)this.buddies_localhost.get(0), results.get(0));
        AssertJUnit.assertEquals((Object)this.buddies_localhost.get(1), results.get(1));
    }

    public void testSingleBuddyWithColocAllCandidatesColoc() {
        LinkedList<Address> list = new LinkedList<Address>();
        list.add((Address)this.dataOwner);
        list.add(this.buddies_localhost.get(0));
        list.add(this.buddies_localhost.get(1));
        List results = this.getBuddies(1, true, list);
        AssertJUnit.assertEquals((int)1, (int)results.size());
        AssertJUnit.assertEquals((Object)this.buddies_localhost.get(0), results.get(0));
    }

    public void testThreeBuddiesWithColocAllCandidatesColoc() {
        LinkedList<Address> list = new LinkedList<Address>();
        list.add((Address)this.dataOwner);
        list.add(this.buddies_localhost.get(0));
        list.add(this.buddies_localhost.get(1));
        list.add(this.buddies_localhost.get(2));
        list.add(this.buddies_localhost.get(3));
        List results = this.getBuddies(3, true, list);
        AssertJUnit.assertEquals((int)3, (int)results.size());
        AssertJUnit.assertEquals((Object)this.buddies_localhost.get(0), results.get(0));
        AssertJUnit.assertEquals((Object)this.buddies_localhost.get(1), results.get(1));
        AssertJUnit.assertEquals((Object)this.buddies_localhost.get(2), results.get(2));
    }

    public void testMoreBuddiesThanAvblWithColocAllCandidatesColoc() {
        LinkedList<Address> list = new LinkedList<Address>();
        list.add((Address)this.dataOwner);
        list.add(this.buddies_localhost.get(0));
        list.add(this.buddies_localhost.get(1));
        List results = this.getBuddies(3, true, list);
        AssertJUnit.assertEquals((int)2, (int)results.size());
        AssertJUnit.assertEquals((Object)this.buddies_localhost.get(0), results.get(0));
        AssertJUnit.assertEquals((Object)this.buddies_localhost.get(1), results.get(1));
    }

    public void testSingleBuddyWithColocAllCandidatesColocDiffNics() {
        LinkedList<Address> list = new LinkedList<Address>();
        list.add((Address)this.dataOwner);
        list.add(this.buddies_localhost.get(0));
        list.add(this.buddies_localhost.get(1));
        list.addAll(this.buddies_same_host_different_nic);
        List results = this.getBuddies(1, true, list);
        AssertJUnit.assertEquals((int)1, (int)results.size());
        AssertJUnit.assertEquals((Object)this.buddies_localhost.get(0), results.get(0));
    }

    public void testThreeBuddiesWithColocAllCandidatesColocDiffNics() {
        LinkedList<Address> list = new LinkedList<Address>();
        list.add((Address)this.dataOwner);
        list.add(this.buddies_localhost.get(0));
        list.add(this.buddies_localhost.get(1));
        list.add(this.buddies_localhost.get(2));
        list.add(this.buddies_localhost.get(3));
        list.addAll(this.buddies_same_host_different_nic);
        List results = this.getBuddies(3, true, list);
        AssertJUnit.assertEquals((int)3, (int)results.size());
        AssertJUnit.assertEquals((Object)this.buddies_localhost.get(0), results.get(0));
        AssertJUnit.assertEquals((Object)this.buddies_localhost.get(1), results.get(1));
        AssertJUnit.assertEquals((Object)this.buddies_localhost.get(2), results.get(2));
    }

    public void testMoreBuddiesThanAvblWithColocAllCandidatesColocDiffNics() {
        LinkedList<Address> list = new LinkedList<Address>();
        list.add((Address)this.dataOwner);
        list.add(this.buddies_localhost.get(0));
        list.add(this.buddies_localhost.get(1));
        list.addAll(this.buddies_same_host_different_nic);
        List results = this.getBuddies(3, true, list);
        AssertJUnit.assertEquals((int)(this.buddies_same_host_different_nic.isEmpty() ? 2 : 3), (int)results.size());
        AssertJUnit.assertEquals((Object)this.buddies_localhost.get(0), results.get(0));
        AssertJUnit.assertEquals((Object)this.buddies_localhost.get(1), results.get(1));
        if (!this.buddies_same_host_different_nic.isEmpty()) {
            AssertJUnit.assertEquals((Object)this.buddies_same_host_different_nic.get(0), results.get(2));
        }
    }

    public void testSingleBuddyWithColocDiffHosts() {
        LinkedList<Address> list = new LinkedList<Address>();
        list.add((Address)this.dataOwner);
        list.add(this.buddies_localhost.get(0));
        list.add(this.buddies_localhost.get(1));
        list.addAll(this.buddies_same_host_different_nic);
        list.addAll(this.buddies_different_hosts);
        List results = this.getBuddies(1, true, list);
        AssertJUnit.assertEquals((int)1, (int)results.size());
        AssertJUnit.assertEquals((Object)this.buddies_different_hosts.get(0), results.get(0));
    }

    public void testThreeBuddiesWithColocDiffHosts() {
        LinkedList<Address> list = new LinkedList<Address>();
        list.add((Address)this.dataOwner);
        list.add(this.buddies_localhost.get(0));
        list.add(this.buddies_localhost.get(1));
        list.add(this.buddies_localhost.get(2));
        list.add(this.buddies_localhost.get(3));
        list.addAll(this.buddies_same_host_different_nic);
        list.addAll(this.buddies_different_hosts);
        List results = this.getBuddies(3, true, list);
        AssertJUnit.assertEquals((int)3, (int)results.size());
        AssertJUnit.assertEquals((Object)this.buddies_different_hosts.get(0), results.get(0));
        AssertJUnit.assertEquals((Object)this.buddies_different_hosts.get(1), results.get(1));
        AssertJUnit.assertEquals((Object)this.buddies_different_hosts.get(2), results.get(2));
    }

    public void testMoreBuddiesThanAvblWithColocDiffHosts() {
        LinkedList<Address> list = new LinkedList<Address>();
        list.add((Address)this.dataOwner);
        list.add(this.buddies_localhost.get(0));
        list.add(this.buddies_localhost.get(1));
        list.add(this.buddies_different_hosts.get(0));
        list.add(this.buddies_different_hosts.get(1));
        List results = this.getBuddies(3, true, list);
        AssertJUnit.assertEquals((int)3, (int)results.size());
        AssertJUnit.assertEquals((Object)this.buddies_different_hosts.get(0), results.get(0));
        AssertJUnit.assertEquals((Object)this.buddies_different_hosts.get(1), results.get(1));
        AssertJUnit.assertEquals((Object)this.buddies_localhost.get(0), results.get(2));
    }

    public void testSingleLocalBuddyWithPool() {
        LinkedList<Address> list = new LinkedList<Address>();
        list.add((Address)this.dataOwner);
        list.add(this.buddies_localhost.get(0));
        list.add(this.buddies_localhost.get(1));
        list.add(this.buddies_localhost.get(2));
        HashMap<Address, String> pool = new HashMap<Address, String>();
        pool.put((Address)this.dataOwner, "A");
        pool.put(this.buddies_localhost.get(2), "A");
        pool.put(this.buddies_localhost.get(0), "B");
        pool.put(this.buddies_localhost.get(1), "B");
        List results = this.getBuddies(1, true, list, pool);
        AssertJUnit.assertEquals((int)1, (int)results.size());
        AssertJUnit.assertEquals((Object)this.buddies_localhost.get(2), results.get(0));
    }

    public void testSingleLocalBuddyWithPoolMixed1() {
        LinkedList<Address> list = new LinkedList<Address>();
        list.add((Address)this.dataOwner);
        list.add(this.buddies_localhost.get(0));
        list.add(this.buddies_localhost.get(1));
        list.add(this.buddies_localhost.get(2));
        list.add(this.buddies_different_hosts.get(0));
        list.add(this.buddies_different_hosts.get(1));
        HashMap<Address, String> pool = new HashMap<Address, String>();
        pool.put((Address)this.dataOwner, "A");
        pool.put(this.buddies_localhost.get(2), "A");
        pool.put(this.buddies_localhost.get(0), "B");
        pool.put(this.buddies_localhost.get(1), "B");
        pool.put(this.buddies_different_hosts.get(0), "C");
        pool.put(this.buddies_different_hosts.get(1), "C");
        List results = this.getBuddies(1, true, list, pool);
        AssertJUnit.assertEquals((int)1, (int)results.size());
        AssertJUnit.assertEquals((Object)this.buddies_localhost.get(2), results.get(0));
    }

    public void testSingleLocalBuddyWithPoolMixed2() {
        LinkedList<Address> list = new LinkedList<Address>();
        list.add((Address)this.dataOwner);
        list.add(this.buddies_localhost.get(0));
        list.add(this.buddies_localhost.get(1));
        list.add(this.buddies_localhost.get(2));
        list.add(this.buddies_different_hosts.get(0));
        list.add(this.buddies_different_hosts.get(1));
        HashMap<Address, String> pool = new HashMap<Address, String>();
        pool.put((Address)this.dataOwner, "A");
        pool.put(this.buddies_localhost.get(2), "B");
        pool.put(this.buddies_localhost.get(0), "B");
        pool.put(this.buddies_localhost.get(1), "B");
        pool.put(this.buddies_different_hosts.get(0), "C");
        pool.put(this.buddies_different_hosts.get(1), "C");
        List results = this.getBuddies(1, true, list, pool);
        AssertJUnit.assertEquals((int)1, (int)results.size());
        AssertJUnit.assertEquals((Object)this.buddies_different_hosts.get(0), results.get(0));
    }

    public void testWithDataOwnerAtEnd() {
        LinkedList<Address> list = new LinkedList<Address>();
        list.addAll(this.buddies_localhost);
        list.add((Address)this.dataOwner);
        List results = this.getBuddies(1, true, list);
        AssertJUnit.assertEquals((int)1, (int)results.size());
        AssertJUnit.assertEquals((Object)this.buddies_localhost.get(0), results.get(0));
    }
}

