/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.cluster;

import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.commands.tx.PrepareCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.util.internals.ReplicationListener;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "transaction"}, testName="cluster.ReplicationQueueTxTest")
public class ReplicationQueueTxTest {
    Cache cache;
    Cache cache2;
    TransactionManager txManager;

    @BeforeMethod
    public void setUp() throws CloneNotSupportedException {
        Configuration c = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_ASYNC);
        this.cache = new UnitTestCacheFactory().createCache(c, false);
        this.cache.getConfiguration().setUseReplQueue(true);
        this.cache.getConfiguration().setReplQueueInterval(100L);
        this.cache.getConfiguration().setReplQueueMaxElements(10);
        this.cache.start();
        this.cache2 = new UnitTestCacheFactory().createCache(this.cache.getConfiguration().clone());
        TestingUtil.blockUntilViewsReceived(60000L, this.cache, this.cache2);
        this.txManager = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches(this.cache, this.cache2);
        this.cache = null;
        this.cache2 = null;
    }

    public void testTransactionalReplication() throws Exception {
        ReplicationListener cache1Listener = new ReplicationListener(this.cache);
        ReplicationListener cache2Listener = new ReplicationListener(this.cache2);
        cache2Listener.expect(PutKeyValueCommand.class);
        this.cache.put("/a", (Object)"k", (Object)"v");
        cache2Listener.waitForReplicationToOccur(5000L);
        assert (this.cache2.get("/a", (Object)"k").equals("v"));
        cache1Listener.expect(PrepareCommand.class);
        this.txManager.begin();
        this.cache2.put("/a", (Object)"k", (Object)"v2");
        this.txManager.commit();
        cache1Listener.waitForReplicationToOccur(5000L);
        assert (this.cache.get("/a", (Object)"k").equals("v2"));
    }
}

