/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.read;

import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.commands.TestContextBase;
import org.jboss.cache.commands.read.GetKeyValueCommand;
import org.jboss.cache.mock.NodeSpiMock;
import org.jboss.cache.notifications.Notifier;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, sequential=true, testName="commands.read.GetKeyValueCommandTest")
public class GetKeyValueCommandTest
extends TestContextBase {
    private IMocksControl control;
    Notifier notifierMock;
    DataContainer containerMock;
    GetKeyValueCommand command;
    Fqn fqn = Fqn.fromString((String)"/dummy");
    String key = "key";
    InvocationContext ctx;

    @BeforeMethod
    protected void setUup() {
        this.control = EasyMock.createStrictControl();
        this.containerMock = (DataContainer)this.control.createMock(DataContainer.class);
        this.notifierMock = (Notifier)this.control.createMock(Notifier.class);
        this.command = new GetKeyValueCommand(this.fqn, (Object)this.key, false);
        this.command.initialize(this.containerMock, this.notifierMock);
        this.ctx = this.createLegacyInvocationContext(this.containerMock);
    }

    public void testNonexistentNodeNoNotifications() {
        EasyMock.expect((Object)this.containerMock.peek(this.fqn)).andReturn(null);
        this.control.replay();
        assert (null == this.command.perform(this.ctx));
    }

    public void testExistentNodeNoNotifications() {
        NodeSpiMock node = new NodeSpiMock(this.fqn);
        String value = "vvv";
        node.put(this.key, value);
        EasyMock.expect((Object)this.containerMock.peek(this.fqn)).andReturn((Object)node);
        this.control.replay();
        assert (value.equals(this.command.perform(this.ctx)));
    }

    public void testNonexistentNodeWithNotifications() {
        this.command.sendNodeEvent = true;
        EasyMock.expect((Object)this.containerMock.peek(this.fqn)).andReturn(null);
        this.control.replay();
        assert (null == this.command.perform(this.ctx));
    }

    public void testExistentNodeWithNotifications() {
        this.command.sendNodeEvent = true;
        NodeSpiMock node = new NodeSpiMock(this.fqn);
        String value = "vvv";
        node.put(this.key, value);
        this.control.checkOrder(false);
        this.notifierMock.notifyNodeVisited(this.fqn, true, this.ctx);
        EasyMock.expect((Object)this.containerMock.peek(this.fqn)).andReturn((Object)node);
        this.notifierMock.notifyNodeVisited(this.fqn, false, this.ctx);
        this.control.replay();
        assert (value.equals(this.command.perform(this.ctx)));
        this.control.verify();
    }
}

