/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config.parsing;

import java.util.List;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.CustomInterceptorConfig;
import org.jboss.cache.config.parsing.XmlConfigHelper;
import org.jboss.cache.config.parsing.custominterceptors.AaaCustomInterceptor;
import org.jboss.cache.config.parsing.custominterceptors.BbbCustomInterceptor;
import org.jboss.cache.config.parsing.element.CustomInterceptorsElementParser;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

@Test(groups={"unit"})
public class CustomInterceptorsElementParserTest {
    CustomInterceptorsElementParser parser = new CustomInterceptorsElementParser();

    public void testFullConfiguration() throws Exception {
        String xml = "   <customInterceptors>\n      <interceptor position=\"first\" class=\"org.jboss.cache.config.parsing.custominterceptors.AaaCustomInterceptor\">\n         <property name=\"attrOne\" value=\"value1\"></property>\n         <property name=\"attrTwo\" value=\"value2\"></property>\n         <property name=\"attrThree\" value=\"value3\"></property>\n      </interceptor>\n      <interceptor position=\"last\" class=\"org.jboss.cache.config.parsing.custominterceptors.BbbCustomInterceptor\"/>\n      <interceptor index=\"3\" class=\"org.jboss.cache.config.parsing.custominterceptors.AaaCustomInterceptor\"/>\n      <interceptor before=\"org.jboss.cache.interceptors.CallInterceptor\"\n                   class=\"org.jboss.cache.config.parsing.custominterceptors.BbbCustomInterceptor\"/>\n      <interceptor after=\"org.jboss.cache.interceptors.CallInterceptor\"\n                   class=\"org.jboss.cache.config.parsing.custominterceptors.AaaCustomInterceptor\"/>\n   </customInterceptors>";
        Element element = XmlConfigHelper.stringToElementInCoreNS((String)xml);
        List configs = this.parser.parseCustomInterceptors(element);
        assert (configs.size() == 5);
        CustomInterceptorConfig one = (CustomInterceptorConfig)configs.get(0);
        assert (one.isFirst());
        assert (one.getInterceptor() instanceof AaaCustomInterceptor);
        assert (((AaaCustomInterceptor)one.getInterceptor()).getAttrOne().equals("value1"));
        assert (((AaaCustomInterceptor)one.getInterceptor()).getAttrTwo().equals("value2"));
        assert (((AaaCustomInterceptor)one.getInterceptor()).getAttrThree().equals("value3"));
        CustomInterceptorConfig two = (CustomInterceptorConfig)configs.get(1);
        assert (!two.isFirst());
        assert (two.isLast());
        assert (two.getInterceptor() instanceof BbbCustomInterceptor);
        CustomInterceptorConfig three = (CustomInterceptorConfig)configs.get(2);
        assert (!three.isFirst());
        assert (!three.isLast());
        assert (three.getIndex() == 3);
        CustomInterceptorConfig four = (CustomInterceptorConfig)configs.get(3);
        assert (!four.isFirst());
        assert (!four.isLast());
        assert (four.getBeforeClass().equals("org.jboss.cache.interceptors.CallInterceptor"));
        CustomInterceptorConfig five = (CustomInterceptorConfig)configs.get(4);
        assert (!five.isFirst());
        assert (!five.isLast());
        assert (five.getAfterClass().equals("org.jboss.cache.interceptors.CallInterceptor"));
    }

    public void testWrongAttribute() throws Exception {
        String xml = "   <customInterceptors>\n      <interceptor position=\"first\" class=\"org.jboss.cache.config.parsing.custominterceptors.AaaCustomInterceptor\">\n         <property name=\"nonexistenAttribute\" value=\"value3\"></property>\n      </interceptor>\n   </customInterceptors>";
        Element el = XmlConfigHelper.stringToElementInCoreNS((String)xml);
        try {
            this.parser.parseCustomInterceptors(el);
            assert (false) : "exception expected";
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public void testBadInterceptorClass() throws Exception {
        String xml = "   <customInterceptors>\n      <interceptor position=\"first\" class=\"org.jboss.cache.config.parsing.custominterceptors.AaaCustomInterceptor\">\n         <property name=\"notExists\" value=\"value1\"></property>\n      </interceptor>\n   </customInterceptors>";
        Element el = XmlConfigHelper.stringToElementInCoreNS((String)xml);
        try {
            this.parser.parseCustomInterceptors(el);
            assert (false) : "exception expected";
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }
}

