/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config.parsing;

import java.util.List;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.CustomInterceptorConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.config.parsing.XmlConfigurationParser;
import org.jboss.cache.config.parsing.custominterceptors.AaaCustomInterceptor;
import org.jboss.cache.config.parsing.custominterceptors.BbbCustomInterceptor;
import org.jboss.cache.eviction.LRUAlgorithmConfig;
import org.jboss.cache.eviction.MRUAlgorithmConfig;
import org.jboss.cache.lock.IsolationLevel;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="config.parsing.XmlConfigurationParserTest")
public class XmlConfigurationParserTest {
    Configuration syncConfig;
    Configuration asyncConfig;

    @BeforeTest
    public void setUp() {
        this.syncConfig = new XmlConfigurationParser(false, null).parseFile("configs/parser-test.xml");
        this.asyncConfig = new XmlConfigurationParser(false, null).parseFile("configs/parser-test-async.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testParseOldConfigFile() {
        System.setProperty("jbosscache.config.validate", "false");
        XmlConfigurationParser parser = new XmlConfigurationParser();
        try {
            try {
                parser.parseFile("configs/conf2x/pess-local.xml");
                assert (false) : "exception expected";
                Object var4_2 = null;
            }
            catch (ConfigurationException configurationException) {
                Object var4_3 = null;
                System.setProperty("jbosscache.config.validate", "true");
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            System.setProperty("jbosscache.config.validate", "true");
            throw throwable;
        }
        System.setProperty("jbosscache.config.validate", "true");
    }

    public void testTransactionManagerLookupClass() {
        assert (this.syncConfig.getTransactionManagerLookupClass().equals("org.jboss.cache.transaction.GenericTransactionManagerLookup"));
    }

    public void testIsolationLevel() {
        assert (this.syncConfig.getIsolationLevel().equals((Object)IsolationLevel.REPEATABLE_READ));
    }

    public void testCacheMode() {
        assert (this.syncConfig.getCacheMode().equals((Object)Configuration.CacheMode.REPL_SYNC)) : "Was " + this.syncConfig.getCacheMode();
        assert (this.asyncConfig.getCacheMode().equals((Object)Configuration.CacheMode.REPL_ASYNC)) : "Was " + this.syncConfig.getCacheMode();
    }

    public void testAsyncSerializationExecutorSize() {
        assert (this.asyncConfig.getSerializationExecutorPoolSize() == 250);
        assert (this.asyncConfig.getSerializationExecutorQueueSize() == 5000000);
    }

    public void testUseReplQueue() {
        assert (!this.syncConfig.isUseReplQueue());
        assert (!this.asyncConfig.isUseReplQueue());
    }

    public void testClusterName() {
        assert (this.syncConfig.getClusterName().equals("JBossCache-cluster"));
    }

    public void testGetClusterConfig() {
        assert (this.asyncConfig.getClusterConfig().indexOf("MERGE2") >= 0);
    }

    public void testFetchInMemoryState() {
        assert (this.syncConfig.isFetchInMemoryState());
    }

    public void testStateRetrievalTimeout() {
        assert (this.syncConfig.getStateRetrievalTimeout() == 15124L);
    }

    public void testSyncReplTimeout() {
        assert (this.syncConfig.getSyncReplTimeout() == 15421L);
    }

    public void testLockAcquisitionTimeout() {
        assert (this.syncConfig.getLockAcquisitionTimeout() == 10234L);
    }

    public void testUseLazyDeserialization() {
        assert (this.syncConfig.isUseLazyDeserialization());
    }

    public void testObjectInputStreamPoolSize() {
        assert (12 == this.syncConfig.getObjectInputStreamPoolSize());
    }

    public void testObjectOutputStreamPoolSize() {
        assert (14 == this.syncConfig.getObjectOutputStreamPoolSize());
    }

    public void testShutdownHookBehavior() {
        assert (Configuration.ShutdownHookBehavior.REGISTER == this.syncConfig.getShutdownHookBehavior());
    }

    public void testSyncRollbackPhase() {
        assert (this.syncConfig.isSyncRollbackPhase());
    }

    public void testSyncCommitPhase() {
        assert (this.syncConfig.isSyncCommitPhase());
    }

    public void testUseReplicationVersion() {
        assert (this.syncConfig.getReplicationVersion() == 124);
    }

    public void testGetMultiplexerStack() {
        assert ("file_name".equals(this.syncConfig.getMultiplexerStack()));
    }

    public void testMarshallerClass() {
        assert ("some.Clazz".equals(this.syncConfig.getMarshallerClass()));
    }

    public void testLockParentForChildInsertRemove() {
        assert (this.syncConfig.isLockParentForChildInsertRemove());
    }

    public void testInactiveOnStartup() {
        assert (this.syncConfig.isInactiveOnStartup());
    }

    public void testExposeManagementStatistics() {
        assert (!this.syncConfig.getExposeManagementStatistics());
    }

    public void testCacheLoaderConfiguration() {
        CacheLoaderConfig clc = this.syncConfig.getCacheLoaderConfig();
        assert (null != clc);
        assert (clc.isPassivation());
        assert (clc.isShared());
        assert ("/a/b/c,/f/r/s".equals(clc.getPreload()));
        CacheLoaderConfig.IndividualCacheLoaderConfig first = clc.getFirstCacheLoaderConfig();
        assert ("org.jboss.cache.loader.JDBCCacheLoader".equals(first.getClassName()));
        assert (first.isAsync());
        assert (first.isFetchPersistentState());
        assert (first.isIgnoreModifications());
        assert (first.isPurgeOnStartup());
        assert (first.getProperties().get("cache.jdbc.table.name").equals("jbosscache"));
        assert (first.getProperties().get("cache.jdbc.table.create").equals("true"));
        assert (first.getProperties().get("cache.jdbc.table.drop").equals("true"));
    }

    public void testBuddyReplicationConfig() {
        BuddyReplicationConfig brConfig = this.syncConfig.getBuddyReplicationConfig();
        assert (brConfig.isEnabled());
        BuddyReplicationConfig.BuddyLocatorConfig locatorConfig = brConfig.getBuddyLocatorConfig();
        assert ("org.jboss.cache.buddyreplication.NextMemberBuddyLocator".equals(locatorConfig.getBuddyLocatorClass()));
        assert (locatorConfig.getBuddyLocatorProperties().get("numBuddies").equals("1"));
        assert (locatorConfig.getBuddyLocatorProperties().get("ignoreColocatedBuddies").equals("true"));
        assert (brConfig.getBuddyPoolName().equals("myBuddyPoolReplicationGroup"));
        assert (brConfig.getBuddyCommunicationTimeout() == 2000);
        assert (brConfig.isAutoDataGravitation());
        assert (brConfig.isDataGravitationRemoveOnFind());
        assert (brConfig.isDataGravitationSearchBackupTrees());
    }

    public void testUseRegionBasedMarshalling() {
        assert (this.syncConfig.isUseRegionBasedMarshalling());
    }

    public void testEvictionPolicyConfig() {
        EvictionConfig evictionConfig = this.syncConfig.getEvictionConfig();
        assert ("org.jboss.cache.eviction.LRUAlgorithm".equals(evictionConfig.getDefaultEvictionRegionConfig().getEvictionAlgorithmConfig().getEvictionAlgorithmClassName()));
        assert (200000 == evictionConfig.getDefaultEvictionRegionConfig().getEventQueueSize());
        assert (5L == evictionConfig.getWakeupInterval());
        List regionConfigs = evictionConfig.getEvictionRegionConfigs();
        assert (regionConfigs.size() == 2);
        EvictionRegionConfig first = evictionConfig.getDefaultEvictionRegionConfig();
        assert (first.getRegionName().equals("/"));
        assert (first.getEvictionAlgorithmConfig() instanceof LRUAlgorithmConfig);
        LRUAlgorithmConfig firstConfiguration = (LRUAlgorithmConfig)first.getEvictionAlgorithmConfig();
        assert (firstConfiguration.getMaxAge() <= 0L);
        assert (firstConfiguration.getTimeToLive() == 1000L);
        assert (firstConfiguration.getMaxNodes() == 5000);
        EvictionRegionConfig second = (EvictionRegionConfig)regionConfigs.get(0);
        LRUAlgorithmConfig secondConfiguration = (LRUAlgorithmConfig)second.getEvictionAlgorithmConfig();
        assert (secondConfiguration.getMaxAge() == -1L);
        assert (secondConfiguration.getTimeToLive() == 1002L);
        assert (secondConfiguration.getMaxNodes() == 5000);
        EvictionRegionConfig third = (EvictionRegionConfig)regionConfigs.get(1);
        MRUAlgorithmConfig thirdConfiguration = (MRUAlgorithmConfig)third.getEvictionAlgorithmConfig();
        assert (thirdConfiguration.getMaxNodes() == 2103);
        assert (thirdConfiguration.getMinTimeToLive() == 22L);
        assert (third.getEventQueueSize() == 21);
    }

    public void testCustomInterceptors() {
        List interceptorConfigs = this.syncConfig.getCustomInterceptors();
        assert (interceptorConfigs.size() == 5);
        assert (((CustomInterceptorConfig)interceptorConfigs.get(0)).getInterceptor() instanceof AaaCustomInterceptor);
        AaaCustomInterceptor a = (AaaCustomInterceptor)((CustomInterceptorConfig)interceptorConfigs.get(0)).getInterceptor();
        assert (a.getAttrOne().equals("value1"));
        assert (a.getAttrTwo().equals("value2"));
        assert (a.getAttrThree() == null);
        assert (((CustomInterceptorConfig)interceptorConfigs.get(1)).getInterceptor() instanceof BbbCustomInterceptor);
        assert (((CustomInterceptorConfig)interceptorConfigs.get(2)).getInterceptor() instanceof AaaCustomInterceptor);
        assert (((CustomInterceptorConfig)interceptorConfigs.get(3)).getInterceptor() instanceof BbbCustomInterceptor);
        assert (((CustomInterceptorConfig)interceptorConfigs.get(4)).getInterceptor() instanceof AaaCustomInterceptor);
        assert (((CustomInterceptorConfig)interceptorConfigs.get(0)).isFirst());
        assert (!((CustomInterceptorConfig)interceptorConfigs.get(0)).isLast());
        assert (((CustomInterceptorConfig)interceptorConfigs.get(1)).isLast());
        assert (((CustomInterceptorConfig)interceptorConfigs.get(2)).getIndex() == 3);
        assert (((CustomInterceptorConfig)interceptorConfigs.get(3)).getBeforeClass().equals("org.jboss.cache.interceptors.CallInterceptor"));
        assert (((CustomInterceptorConfig)interceptorConfigs.get(4)).getAfterClass().equals("org.jboss.cache.interceptors.CallInterceptor"));
    }

    public void testSingletonStore() {
        CacheLoaderConfig.IndividualCacheLoaderConfig clc = this.syncConfig.getCacheLoaderConfig().getFirstCacheLoaderConfig();
        assert (clc != null);
        CacheLoaderConfig.IndividualCacheLoaderConfig.SingletonStoreConfig singlStoreConf = clc.getSingletonStoreConfig();
        assert (singlStoreConf != null);
        assert (singlStoreConf.isSingletonStoreEnabled());
        assert (singlStoreConf.getSingletonStoreClass().equals("org.jboss.cache.loader.SingletonStoreCacheLoader"));
        assert (singlStoreConf.getProperties().size() == 2);
        assert (singlStoreConf.getProperties().get("pushStateWhenCoordinator").equals("true"));
        assert (singlStoreConf.getProperties().get("pushStateWhenCoordinatorTimeout").equals("20000"));
    }

    public void testMvccAttributes() {
        assert (!this.syncConfig.isWriteSkewCheck());
        assert (this.syncConfig.getConcurrencyLevel() == 21);
    }

    public void testListenerAsyncThreads() {
        assert (this.syncConfig.getListenerAsyncPoolSize() == 5);
        assert (this.syncConfig.getListenerAsyncQueueSize() == 50000);
        assert (this.asyncConfig.getListenerAsyncPoolSize() == 5);
        assert (this.asyncConfig.getListenerAsyncQueueSize() == 100000);
    }

    public void testInvocationBatching() {
        assert (this.syncConfig.isInvocationBatchingEnabled());
    }
}

