/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.RegionImpl;
import org.jboss.cache.RegionManager;
import org.jboss.cache.RegionManagerImpl;
import org.jboss.cache.RegionRegistry;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.BaseEvictionAlgorithm;
import org.jboss.cache.eviction.EvictionAlgorithm;
import org.jboss.cache.eviction.EvictionEvent;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.LRUQueue;
import org.jboss.cache.eviction.NodeEntry;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="eviction.BaseEvictionAlgorithmTest")
public class BaseEvictionAlgorithmTest {
    private static final Log log = LogFactory.getLog(BaseEvictionAlgorithmTest.class);
    private RegionManager regionManager;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        RegionManagerImpl rmi = new RegionManagerImpl();
        rmi.injectDependencies(null, new Configuration(), null, null, null, new RegionRegistry());
        this.regionManager = rmi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testFillUpRecycleQueue() throws Exception {
        int recycleQueueCapacity = 10;
        MockEvictionAlgorithm algorithm = new MockEvictionAlgorithm(10);
        Region region = this.regionManager.getRegion("/a/b/c", true);
        region.setEvictionRegionConfig(new EvictionRegionConfig(region.getFqn(), (EvictionAlgorithmConfig)new MockEvictionAlgorithmConfig()));
        for (int i = 0; i < 11; ++i) {
            Fqn fqn = Fqn.fromString((String)("/a/b/c/" + Integer.toString(i + 1)));
            region.registerEvictionEvent(fqn, EvictionEvent.Type.ADD_NODE_EVENT);
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Void> future = executor.submit(new ProcessEvictionRegion((RegionImpl)region, (EvictionAlgorithm)algorithm));
        try {
            try {
                future.get(20L, TimeUnit.SECONDS);
            }
            catch (TimeoutException te) {
                log.error((Object)"Region eviction processing did not finish on time", (Throwable)te);
                AssertJUnit.fail((String)"Region eviction processing should have finished by now, something is wrong. Recycle queue may have filled up.");
                Object var8_8 = null;
                log.info((Object)("recycle queue size: " + algorithm.recycleQueue.size()));
                return;
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            log.info((Object)("recycle queue size: " + algorithm.recycleQueue.size()));
            throw throwable;
        }
        log.info((Object)("recycle queue size: " + algorithm.recycleQueue.size()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ProcessEvictionRegion
    implements Callable<Void> {
        private RegionImpl region;
        private EvictionAlgorithm algorithm;

        public ProcessEvictionRegion(RegionImpl region, EvictionAlgorithm algorithm) {
            this.region = region;
            this.algorithm = algorithm;
        }

        @Override
        public Void call() throws Exception {
            try {
                this.algorithm.process(this.region.getEvictionEventQueue());
            }
            catch (EvictionException e) {
                log.error((Object)"Eviction exception reported", (Throwable)e);
                AssertJUnit.fail((String)("Eviction exception reported" + (Object)((Object)e)));
            }
            return null;
        }
    }

    public static class MockEvictionAlgorithmConfig
    implements EvictionAlgorithmConfig {
        public void reset() {
        }

        public String getEvictionAlgorithmClassName() {
            return MockEvictionAlgorithm.class.getName();
        }

        public void validate() throws ConfigurationException {
        }

        public EvictionAlgorithmConfig clone() throws CloneNotSupportedException {
            return (EvictionAlgorithmConfig)super.clone();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MockEvictionAlgorithm
    extends BaseEvictionAlgorithm {
        private static MockEvictionAlgorithm singleton;

        private MockEvictionAlgorithm(int recycleQueueCapacity) {
            this.recycleQueue = new LinkedBlockingQueue(recycleQueueCapacity);
            singleton = this;
        }

        public static MockEvictionAlgorithm getInstance() {
            return singleton;
        }

        protected EvictionQueue setupEvictionQueue() throws EvictionException {
            return new LRUQueue();
        }

        protected boolean shouldEvictNode(NodeEntry ne) {
            return true;
        }

        public Class<? extends EvictionAlgorithmConfig> getConfigurationClass() {
            return null;
        }
    }
}

