/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.io.IOException;
import java.util.Properties;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.LRUAlgorithmConfig;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true, testName="eviction.ConcurrentEvictionTest")
public class ConcurrentEvictionTest {
    private Cache<Integer, String> cache;
    private long wakeupIntervalMillis = 0L;
    private String tmpDir = System.getProperty("java.io.tmpdir", "/tmp");
    private String cacheLoaderDir = "/JBossCacheFileCacheLoader";

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.initCaches();
        this.wakeupIntervalMillis = this.cache.getConfiguration().getEvictionConfig().getWakeupInterval();
        if (this.wakeupIntervalMillis < 0L) {
            AssertJUnit.fail((String)("testEviction(): eviction thread wake up interval is illegal " + this.wakeupIntervalMillis));
        }
    }

    void initCaches() throws Exception {
        TestingUtil.recursiveFileRemove(this.tmpDir + this.cacheLoaderDir);
        UnitTestCacheFactory factory = new UnitTestCacheFactory();
        Configuration conf = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL, true);
        conf.setEvictionConfig(this.buildEvictionConfig());
        conf.setCacheLoaderConfig(this.buildCacheLoaderConfig());
        conf.setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache = factory.createCache(conf, true);
    }

    private CacheLoaderConfig buildCacheLoaderConfig() throws IOException {
        CacheLoaderConfig cacheLoaderConfig = new CacheLoaderConfig();
        cacheLoaderConfig.setPassivation(false);
        cacheLoaderConfig.setPreload("/");
        cacheLoaderConfig.setShared(false);
        CacheLoaderConfig.IndividualCacheLoaderConfig iclc = new CacheLoaderConfig.IndividualCacheLoaderConfig();
        iclc.setClassName("org.jboss.cache.loader.FileCacheLoader");
        Properties p = new Properties();
        p.put("location", this.tmpDir + this.cacheLoaderDir);
        iclc.setProperties(p);
        iclc.setAsync(false);
        iclc.setFetchPersistentState(true);
        iclc.setIgnoreModifications(false);
        cacheLoaderConfig.addIndividualCacheLoaderConfig(iclc);
        return cacheLoaderConfig;
    }

    private EvictionConfig buildEvictionConfig() {
        return new EvictionConfig(new EvictionRegionConfig(Fqn.ROOT, (EvictionAlgorithmConfig)new LRUAlgorithmConfig(1000000L, 5000L)), 200);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.recursiveFileRemove(this.tmpDir + this.cacheLoaderDir);
        TestingUtil.killCaches(this.cache);
        this.cache = null;
    }

    public void testConcurrentEviction() throws Exception {
        Fqn base = Fqn.fromString((String)"/org/jboss/test/data/concurrent/eviction");
        for (int i = 0; i < 1000; ++i) {
            this.cache.put(Fqn.fromRelativeElements((Fqn)base, (Object[])new Integer[]{i / 100}), (Object)i, (Object)"value");
        }
        long loopDone = System.currentTimeMillis() + 5L * this.wakeupIntervalMillis;
        while (System.currentTimeMillis() < loopDone) {
            for (int i = 0; i < 1000; ++i) {
                Fqn fqn = Fqn.fromRelativeElements((Fqn)base, (Object[])new Integer[]{i / 100});
                AssertJUnit.assertNotNull((String)("found value under Fqn " + fqn + " and key " + i), (Object)this.cache.get(fqn, (Object)i));
            }
        }
    }
}

