/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.ElementSizeAlgorithmConfig;
import org.jboss.cache.eviction.EvictionTestsBase;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.util.internals.EvictionController;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true, testName="eviction.ElementSizePolicyTest")
public class ElementSizePolicyTest
extends EvictionTestsBase {
    CacheSPI<Object, Object> cache;
    long wakeupIntervalMillis = 0L;
    final String ROOT_STR = "/test";
    Throwable t1_ex;
    Throwable t2_ex;
    final long DURATION = 10000L;
    boolean isTrue;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.initCaches();
        this.wakeupIntervalMillis = this.cache.getConfiguration().getEvictionConfig().getWakeupInterval();
        if (this.wakeupIntervalMillis < 0L) {
            AssertJUnit.fail((String)("testEviction(): eviction thread wake up interval is illegal " + this.wakeupIntervalMillis));
        }
        this.t2_ex = null;
        this.t1_ex = null;
        this.isTrue = true;
    }

    void initCaches() throws Exception {
        Configuration conf = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL, true);
        EvictionConfig evConfig = new EvictionConfig(new EvictionRegionConfig(Fqn.ROOT, (EvictionAlgorithmConfig)new ElementSizeAlgorithmConfig(5000, 100), 200000), 200);
        evConfig.addEvictionRegionConfig(new EvictionRegionConfig(Fqn.fromString((String)"/org/jboss/data"), (EvictionAlgorithmConfig)new ElementSizeAlgorithmConfig(10, 20)));
        evConfig.addEvictionRegionConfig(new EvictionRegionConfig(Fqn.fromString((String)"/org/jboss/test/data"), (EvictionAlgorithmConfig)new ElementSizeAlgorithmConfig(-1, 5)));
        evConfig.addEvictionRegionConfig(new EvictionRegionConfig(Fqn.fromString((String)"/test/"), (EvictionAlgorithmConfig)new ElementSizeAlgorithmConfig(5000, 1)));
        conf.setEvictionConfig(evConfig);
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(conf, false);
        this.cache.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.SERIALIZABLE);
        this.cache.start();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
    }

    public void testEviction() throws Exception {
        String rootStr = "/org/jboss/test/data/";
        for (int i = 0; i < 10; ++i) {
            String str = rootStr + i;
            Fqn fqn = Fqn.fromString((String)str);
            try {
                this.cache.put(fqn, (Object)str, (Object)str);
                if (i % 2 != 0) continue;
                for (int k = 0; k < i; ++k) {
                    this.cache.put(fqn, (Object)k, (Object)Integer.toString(k));
                }
                continue;
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Failed to insert data" + e));
                e.printStackTrace();
            }
        }
        System.out.println(this.cache);
        EvictionController evController = new EvictionController((Cache)this.cache);
        evController.startEviction();
        TestingUtil.sleepThread(200L);
        System.out.println(this.cache);
        for (int i = 0; i < 10; ++i) {
            String f = "/org/jboss/test/data/" + i;
            NodeSPI node = this.cache.getNode(f);
            System.out.println("Node for " + f + " is " + node);
            if (i % 2 == 0) {
                if (i < 6) {
                    int numElements = node.getDataDirect().size();
                    AssertJUnit.assertEquals((int)(i + 1), (int)numElements);
                    continue;
                }
                AssertJUnit.assertNull((Object)node);
                continue;
            }
            AssertJUnit.assertEquals((int)1, (int)node.getDataDirect().size());
        }
    }

    public void testEviction2() throws Exception {
        Fqn fqn;
        String str;
        int i;
        ArrayList<Fqn> fqnsThatShouldBeEvicted = new ArrayList<Fqn>();
        for (int i2 = 10; i2 < 20; ++i2) {
            fqnsThatShouldBeEvicted.add(Fqn.fromString((String)("/org/jboss/data/" + i2)));
        }
        EvictionController evictionController = new EvictionController((Cache)this.cache);
        String rootStr = "/org/jboss/data/";
        for (i = 0; i < 20; ++i) {
            str = rootStr + Integer.toString(i);
            fqn = Fqn.fromString((String)str);
            this.cache.put(fqn, (Object)i, (Object)str);
            for (int k = 0; k < i; ++k) {
                this.cache.put(fqn, (Object)k, (Object)str);
            }
        }
        evictionController.startEviction();
        for (i = 0; i < 20; ++i) {
            str = rootStr + Integer.toString(i);
            fqn = Fqn.fromString((String)str);
            NodeSPI node = this.cache.getNode(fqn);
            System.out.println(i + " " + node);
            if (i > 9) {
                AssertJUnit.assertNull((String)("Testing at " + i), (Object)node);
                continue;
            }
            AssertJUnit.assertEquals((int)(1 + i), (int)node.getData().size());
        }
        for (i = 0; i < 17; ++i) {
            this.cache.put("/org/jboss/data/3", (Object)(100 + i), (Object)"value");
        }
        NodeSPI node = this.cache.getNode("/org/jboss/data/3");
        AssertJUnit.assertEquals((int)21, (int)node.getData().size());
        assert (this.waitForEviction((Cache)this.cache, 30L, TimeUnit.SECONDS, Fqn.fromString((String)"/org/jboss/data/3"))) : "Eviction event not received!";
        TestingUtil.sleepThread(200L);
        AssertJUnit.assertNull((Object)this.cache.getNode("/org/jboss/data/3"));
    }

    class MyPutter
    extends Thread {
        public MyPutter(String name) {
            super(name);
        }

        public void run() {
            int i = 0;
            String myName = "/test/test1/node" + this.getName();
            while (ElementSizePolicyTest.this.isTrue) {
                try {
                    ElementSizePolicyTest.this.cache.put(myName + i++, (Object)"value", (Object)i);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    if (ElementSizePolicyTest.this.t1_ex != null) continue;
                    ElementSizePolicyTest.this.t1_ex = e;
                }
            }
        }
    }
}

