/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.EvictionTestsBase;
import org.jboss.cache.eviction.ExpirationAlgorithmConfig;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.util.internals.EvictionController;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true, testName="eviction.ExpirationPolicyTest")
public class ExpirationPolicyTest
extends EvictionTestsBase {
    private static final Log log = LogFactory.getLog(ExpirationPolicyTest.class);
    private CacheSPI<Object, Object> cache;
    Fqn fqn1 = Fqn.fromString((String)"/node/1");
    Fqn fqn2 = Fqn.fromString((String)"/node/2");
    Fqn fqn3 = Fqn.fromString((String)"/node/3");
    Fqn fqn4 = Fqn.fromString((String)"/node/4");
    Long future;
    Long past;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        Configuration conf = new Configuration();
        ExpirationAlgorithmConfig eAC = new ExpirationAlgorithmConfig();
        EvictionRegionConfig eRC = new EvictionRegionConfig(Fqn.ROOT, (EvictionAlgorithmConfig)eAC);
        EvictionConfig econf = new EvictionConfig(eRC);
        econf.setWakeupInterval(100L);
        conf.setEvictionConfig(econf);
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(conf, false);
        this.cache.start();
        this.future = System.currentTimeMillis() + 500L;
        this.past = System.currentTimeMillis() - 200L;
        System.out.println(eAC);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateToFuture() throws Exception {
        try {
            log.info((Object)"update 1 from future to past");
            this.cache.put(this.fqn1, (Object)"expiration", (Object)this.future);
            TestingUtil.sleepThread(200L);
            new EvictionController((Cache)this.cache).startEviction();
            AssertJUnit.assertNotNull((Object)this.cache.getNode(this.fqn1));
            this.cache.put(this.fqn1, (Object)"expiration", (Object)(this.future + 250L));
            TestingUtil.sleepThread(500L);
            new EvictionController((Cache)this.cache).startEviction();
            AssertJUnit.assertNotNull((Object)this.cache.getNode(this.fqn1));
            TestingUtil.sleepThread(100L);
            new EvictionController((Cache)this.cache).startEviction();
            AssertJUnit.assertNull((Object)this.cache.getNode(this.fqn1));
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.cache.removeNode(Fqn.ROOT);
            throw throwable;
        }
        this.cache.removeNode(Fqn.ROOT);
    }

    @Test
    public void testEviction() throws Exception {
        this.cache.put(this.fqn1, (Object)"expiration", (Object)this.future);
        this.cache.put(this.fqn2, (Object)"expiration", (Object)this.past);
        this.cache.put(this.fqn3, (Object)"expiration", (Object)this.future);
        this.cache.put(this.fqn4, (Object)"foo", (Object)"bar");
        this.waitForEviction((Cache)this.cache, 30L, TimeUnit.SECONDS, this.fqn2);
        AssertJUnit.assertNotNull((Object)this.cache.getNode(this.fqn1));
        AssertJUnit.assertNull((Object)this.cache.getNode(this.fqn2));
        AssertJUnit.assertNotNull((Object)this.cache.getNode(this.fqn3));
        AssertJUnit.assertNotNull((Object)this.cache.getNode(this.fqn4));
        log.info((Object)"should remove 1 and 3 now");
        this.waitForEviction((Cache)this.cache, 30L, TimeUnit.SECONDS, this.fqn1, this.fqn3);
        AssertJUnit.assertNull((Object)this.cache.getNode(this.fqn1));
        AssertJUnit.assertNull((Object)this.cache.getNode(this.fqn3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdate() throws Exception {
        try {
            log.info((Object)"update 1 from future to past");
            this.cache.put(this.fqn1, (Object)"expiration", (Object)this.future);
            new EvictionController((Cache)this.cache).startEviction();
            AssertJUnit.assertNotNull((Object)this.cache.getNode(this.fqn1));
            this.cache.put(this.fqn1, (Object)"expiration", (Object)this.past);
            new EvictionController((Cache)this.cache).startEviction();
            AssertJUnit.assertNull((Object)this.cache.getNode(this.fqn1));
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.cache.removeNode(Fqn.ROOT);
            throw throwable;
        }
        this.cache.removeNode(Fqn.ROOT);
    }

    public void testMaxNodes() throws Exception {
        log.info((Object)"set max nodes to 2, expire soonest to expire first");
        EvictionRegionConfig regionConfig = ((Region)this.cache.getRegionManager().getAllRegions(Region.Type.EVICTION).get(0)).getEvictionRegionConfig();
        ExpirationAlgorithmConfig ec = (ExpirationAlgorithmConfig)regionConfig.getEvictionAlgorithmConfig();
        ec.setMaxNodes(2);
        Long future2 = this.future + 500L;
        this.cache.put(this.fqn1, (Object)"expiration", (Object)future2);
        this.cache.put(this.fqn2, (Object)"expiration", (Object)future2);
        this.cache.put(this.fqn3, (Object)"expiration", (Object)this.future);
        this.cache.put(this.fqn4, (Object)"expiration", (Object)this.past);
        AssertJUnit.assertEquals((int)5, (int)this.cache.getNumberOfNodes());
        assert (this.waitForEviction((Cache)this.cache, 30L, TimeUnit.SECONDS, this.fqn3)) : "Eviction event not received!";
        AssertJUnit.assertNotNull((Object)this.cache.getNode(this.fqn1));
        AssertJUnit.assertNotNull((Object)this.cache.getNode(this.fqn2));
        AssertJUnit.assertNull((Object)this.cache.getNode(this.fqn3));
        AssertJUnit.assertNull((Object)this.cache.getNode(this.fqn4));
    }
}

