/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.concurrent.TimeUnit;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.RegionImpl;
import org.jboss.cache.RegionManager;
import org.jboss.cache.RegionManagerImpl;
import org.jboss.cache.RegionRegistry;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.EvictionAlgorithm;
import org.jboss.cache.eviction.EvictionEvent;
import org.jboss.cache.eviction.LRUAlgorithm;
import org.jboss.cache.eviction.LRUAlgorithmConfig;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true, testName="eviction.RegionTest")
public class RegionTest {
    RegionManager regionManager;
    EvictionAlgorithm algorithm;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.algorithm = new LRUAlgorithm();
        this.regionManager = new RegionManagerImpl();
        ((RegionManagerImpl)this.regionManager).injectDependencies(null, null, null, null, null, new RegionRegistry());
        Region r = this.regionManager.getRegion("/a/b", true);
        r.setEvictionRegionConfig(new EvictionRegionConfig(r.getFqn(), (EvictionAlgorithmConfig)new LRUAlgorithmConfig()));
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.algorithm = null;
        this.regionManager = null;
    }

    public void testAddedQueue() throws InterruptedException {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/e");
        Region region = this.regionManager.getRegion("/a/b", true);
        region.registerEvictionEvent(fqn1, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn2, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn3, EvictionEvent.Type.ADD_NODE_EVENT);
        AssertJUnit.assertEquals((String)"queue size ", (int)3, (int)this.getQueueSize((RegionImpl)region));
        EvictionEvent node = this.takeLastEvent((RegionImpl)region);
        Fqn fqn = node.getFqn();
        AssertJUnit.assertEquals((String)"DataNode retrieved should be FILO ", (Object)fqn, (Object)fqn1);
        AssertJUnit.assertEquals((String)"AddedNode queue size ", (int)2, (int)this.getQueueSize((RegionImpl)region));
        fqn = this.takeLastEvent((RegionImpl)region).getFqn();
        fqn = this.takeLastEvent((RegionImpl)region).getFqn();
        node = this.takeLastEvent((RegionImpl)region);
        AssertJUnit.assertNull((String)"DataNode should be null", (Object)node);
    }

    public void testEventQueue() throws InterruptedException {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/e");
        Region region = this.regionManager.getRegion("/a/b", true);
        region.registerEvictionEvent(fqn1, EvictionEvent.Type.REMOVE_NODE_EVENT);
        region.registerEvictionEvent(fqn2, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn3, EvictionEvent.Type.VISIT_NODE_EVENT);
        AssertJUnit.assertEquals((String)"RemovedNode queue size ", (int)3, (int)this.getQueueSize((RegionImpl)region));
        EvictionEvent.Type event = this.takeLastEvent((RegionImpl)region).getEventType();
        AssertJUnit.assertEquals((String)"DataNode retrieved should be: ", (Object)EvictionEvent.Type.REMOVE_NODE_EVENT, (Object)event);
        this.takeLastEvent((RegionImpl)region);
        this.takeLastEvent((RegionImpl)region);
        EvictionEvent node = this.takeLastEvent((RegionImpl)region);
        AssertJUnit.assertNull((String)"DataNode should be null", (Object)node);
    }

    public void testMassivePutOnQueue() {
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Region region = this.regionManager.getRegion("/a/b", true);
        for (int i = 0; i < 199999; ++i) {
            region.registerEvictionEvent(fqn2, EvictionEvent.Type.ADD_NODE_EVENT);
        }
    }

    void log(String msg) {
        System.out.println("-- " + msg);
    }

    EvictionEvent takeLastEvent(RegionImpl r) throws InterruptedException {
        return (EvictionEvent)r.getEvictionEventQueue().poll(0L, TimeUnit.MILLISECONDS);
    }

    int getQueueSize(RegionImpl r) {
        return r.getEvictionEventQueue().size();
    }
}

