/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction.minttl;

import org.jboss.cache.CacheStatus;
import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.EvictionAlgorithmConfigBase;
import org.jboss.cache.eviction.MRUAlgorithmConfig;
import org.jboss.cache.eviction.minttl.MinTTLTestBase;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="eviction.minttl.MRUMinTTLTest")
public class MRUMinTTLTest
extends MinTTLTestBase {
    private Fqn fqn2;

    public MRUMinTTLTest() {
        this.fqn2 = Fqn.fromRelativeElements((Fqn)this.region, (Object[])new String[]{"b"});
    }

    protected EvictionAlgorithmConfigBase getEvictionAlgorithmConfig() {
        MRUAlgorithmConfig cfg = new MRUAlgorithmConfig();
        cfg.setMaxNodes(1);
        this.startBusyThread();
        return cfg;
    }

    private void startBusyThread() {
        Thread busyThread = new Thread(){

            public void run() {
                while (true) {
                    if (MRUMinTTLTest.this.cache != null && MRUMinTTLTest.this.cache.getCacheStatus() == CacheStatus.STARTED && MRUMinTTLTest.this.cache.getRoot().hasChild(MRUMinTTLTest.this.fqn)) break;
                    TestingUtil.sleepRandom(50);
                }
                MRUMinTTLTest.this.cache.put(MRUMinTTLTest.this.fqn2, (Object)"k", (Object)"v");
            }
        };
        busyThread.setDaemon(true);
        busyThread.start();
    }
}

